@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.inputs

import com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsFaceSearchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property collectionId ID of a collection that contains faces that you want to search for.
 * @property faceMatchThreshold Minimum face match confidence score that must be met to return a result for a recognized face.
 */
public data class StreamProcessorSettingsFaceSearchArgs(
    public val collectionId: Output<String>,
    public val faceMatchThreshold: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsFaceSearchArgs> {
    override fun toJava(): com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsFaceSearchArgs =
        com.pulumi.aws.rekognition.inputs.StreamProcessorSettingsFaceSearchArgs.builder()
            .collectionId(collectionId.applyValue({ args0 -> args0 }))
            .faceMatchThreshold(faceMatchThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamProcessorSettingsFaceSearchArgs].
 */
@PulumiTagMarker
public class StreamProcessorSettingsFaceSearchArgsBuilder internal constructor() {
    private var collectionId: Output<String>? = null

    private var faceMatchThreshold: Output<Double>? = null

    /**
     * @param value ID of a collection that contains faces that you want to search for.
     */
    @JvmName("cqrbyoknkxsjeoko")
    public suspend fun collectionId(`value`: Output<String>) {
        this.collectionId = value
    }

    /**
     * @param value Minimum face match confidence score that must be met to return a result for a recognized face.
     */
    @JvmName("pyisqoywpquumavr")
    public suspend fun faceMatchThreshold(`value`: Output<Double>) {
        this.faceMatchThreshold = value
    }

    /**
     * @param value ID of a collection that contains faces that you want to search for.
     */
    @JvmName("ygfymvtladotepvk")
    public suspend fun collectionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collectionId = mapped
    }

    /**
     * @param value Minimum face match confidence score that must be met to return a result for a recognized face.
     */
    @JvmName("swodghiapqckaelt")
    public suspend fun faceMatchThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.faceMatchThreshold = mapped
    }

    internal fun build(): StreamProcessorSettingsFaceSearchArgs =
        StreamProcessorSettingsFaceSearchArgs(
            collectionId = collectionId ?: throw PulumiNullFieldException("collectionId"),
            faceMatchThreshold = faceMatchThreshold,
        )
}
