@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property kinesisDataStream The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results. See `kinesis_data_stream`.
 * @property s3Destination The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. See `s3_destination`.
 */
public data class StreamProcessorOutput(
    public val kinesisDataStream: StreamProcessorOutputKinesisDataStream? = null,
    public val s3Destination: StreamProcessorOutputS3Destination? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rekognition.outputs.StreamProcessorOutput): StreamProcessorOutput = StreamProcessorOutput(
            kinesisDataStream = javaType.kinesisDataStream().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.rekognition.kotlin.outputs.StreamProcessorOutputKinesisDataStream.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3Destination = javaType.s3Destination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.rekognition.kotlin.outputs.StreamProcessorOutputS3Destination.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
