@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket Name of the Amazon S3 bucket you want to associate with the streaming video project.
 * @property keyPrefix The prefix value of the location within the bucket that you want the information to be published to.
 */
public data class StreamProcessorOutputS3Destination(
    public val bucket: String? = null,
    public val keyPrefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rekognition.outputs.StreamProcessorOutputS3Destination): StreamProcessorOutputS3Destination = StreamProcessorOutputS3Destination(
            bucket = javaType.bucket().map({ args0 -> args0 }).orElse(null),
            keyPrefix = javaType.keyPrefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
