@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property boundingBox Box representing a region of interest on screen. Only 1 per region is allowed. See `bounding_box`.
 * @property polygons Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
 */
public data class StreamProcessorRegionsOfInterest(
    public val boundingBox: StreamProcessorRegionsOfInterestBoundingBox? = null,
    public val polygons: List<StreamProcessorRegionsOfInterestPolygon>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rekognition.outputs.StreamProcessorRegionsOfInterest): StreamProcessorRegionsOfInterest = StreamProcessorRegionsOfInterest(
            boundingBox = javaType.boundingBox().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.rekognition.kotlin.outputs.StreamProcessorRegionsOfInterestBoundingBox.Companion.toKotlin(args0)
                })
            }).orElse(null),
            polygons = javaType.polygons().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.rekognition.kotlin.outputs.StreamProcessorRegionsOfInterestPolygon.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
