@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property height Height of the bounding box as a ratio of the overall image height.
 * @property left Left coordinate of the bounding box as a ratio of overall image width.
 * @property top Top coordinate of the bounding box as a ratio of overall image height.
 * @property width Width of the bounding box as a ratio of the overall image width.
 */
public data class StreamProcessorRegionsOfInterestBoundingBox(
    public val height: Double? = null,
    public val left: Double? = null,
    public val top: Double? = null,
    public val width: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rekognition.outputs.StreamProcessorRegionsOfInterestBoundingBox): StreamProcessorRegionsOfInterestBoundingBox = StreamProcessorRegionsOfInterestBoundingBox(
            height = javaType.height().map({ args0 -> args0 }).orElse(null),
            left = javaType.left().map({ args0 -> args0 }).orElse(null),
            top = javaType.top().map({ args0 -> args0 }).orElse(null),
            width = javaType.width().map({ args0 -> args0 }).orElse(null),
        )
    }
}
