@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property connectedHome Label detection settings to use on a streaming video. See `connected_home`.
 * @property faceSearch Input face recognition parameters for an Amazon Rekognition stream processor. See `face_search`.
 */
public data class StreamProcessorSettings(
    public val connectedHome: StreamProcessorSettingsConnectedHome? = null,
    public val faceSearch: StreamProcessorSettingsFaceSearch? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rekognition.outputs.StreamProcessorSettings): StreamProcessorSettings = StreamProcessorSettings(
            connectedHome = javaType.connectedHome().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.rekognition.kotlin.outputs.StreamProcessorSettingsConnectedHome.Companion.toKotlin(args0)
                })
            }).orElse(null),
            faceSearch = javaType.faceSearch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.rekognition.kotlin.outputs.StreamProcessorSettingsFaceSearch.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
