@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property labels Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: `PERSON`, `PET`, `PACKAGE`, and `ALL`.
 * @property minConfidence Minimum confidence required to label an object in the video.
 */
public data class StreamProcessorSettingsConnectedHome(
    public val labels: List<String>? = null,
    public val minConfidence: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rekognition.outputs.StreamProcessorSettingsConnectedHome): StreamProcessorSettingsConnectedHome = StreamProcessorSettingsConnectedHome(
            labels = javaType.labels().map({ args0 -> args0 }),
            minConfidence = javaType.minConfidence().map({ args0 -> args0 }).orElse(null),
        )
    }
}
