@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rekognition.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property collectionId ID of a collection that contains faces that you want to search for.
 * @property faceMatchThreshold Minimum face match confidence score that must be met to return a result for a recognized face.
 */
public data class StreamProcessorSettingsFaceSearch(
    public val collectionId: String,
    public val faceMatchThreshold: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rekognition.outputs.StreamProcessorSettingsFaceSearch): StreamProcessorSettingsFaceSearch = StreamProcessorSettingsFaceSearch(
            collectionId = javaType.collectionId(),
            faceMatchThreshold = javaType.faceMatchThreshold().map({ args0 -> args0 }).orElse(null),
        )
    }
}
