@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin

import com.pulumi.aws.resourceexplorer.IndexArgs.builder
import com.pulumi.aws.resourceexplorer.kotlin.inputs.IndexTimeoutsArgs
import com.pulumi.aws.resourceexplorer.kotlin.inputs.IndexTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a Resource Explorer index in the current AWS Region.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.resourceexplorer.Index("example", {type: "LOCAL"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.resourceexplorer.Index("example", type="LOCAL")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ResourceExplorer.Index("example", new()
 *     {
 *         Type = "LOCAL",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourceexplorer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resourceexplorer.NewIndex(ctx, "example", &resourceexplorer.IndexArgs{
 * 			Type: pulumi.String("LOCAL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourceexplorer.Index;
 * import com.pulumi.aws.resourceexplorer.IndexArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .type("LOCAL")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:resourceexplorer:Index
 *     properties:
 *       type: LOCAL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Resource Explorer indexes using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:resourceexplorer/index:Index example arn:aws:resource-explorer-2:us-east-1:123456789012:index/6047ac4e-207e-4487-9bcf-cb53bb0ff5cc
 * ```
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 * @property type The type of the index. Valid values: `AGGREGATOR`, `LOCAL`. To understand the difference between `LOCAL` and `AGGREGATOR`, see the [_AWS Resource Explorer User Guide_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html).
 */
public data class IndexArgs(
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<IndexTimeoutsArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.resourceexplorer.IndexArgs> {
    override fun toJava(): com.pulumi.aws.resourceexplorer.IndexArgs =
        com.pulumi.aws.resourceexplorer.IndexArgs.builder()
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexArgs].
 */
@PulumiTagMarker
public class IndexArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<IndexTimeoutsArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xoumicmkqvjrhugi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ybbkyrevvmclstxj")
    public suspend fun timeouts(`value`: Output<IndexTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The type of the index. Valid values: `AGGREGATOR`, `LOCAL`. To understand the difference between `LOCAL` and `AGGREGATOR`, see the [_AWS Resource Explorer User Guide_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html).
     */
    @JvmName("bxdteuuxsbhyxxdx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oprttuybudlyjfih")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xyatlshxrmbsxoky")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("hhivjxsipcntqdbi")
    public suspend fun timeouts(`value`: IndexTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nmkbrpeawmqrdcue")
    public suspend fun timeouts(argument: suspend IndexTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = IndexTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value The type of the index. Valid values: `AGGREGATOR`, `LOCAL`. To understand the difference between `LOCAL` and `AGGREGATOR`, see the [_AWS Resource Explorer User Guide_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html).
     */
    @JvmName("qymqisfqtbewboct")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IndexArgs = IndexArgs(
        tags = tags,
        timeouts = timeouts,
        type = type,
    )
}
