@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin

import com.pulumi.aws.resourceexplorer.kotlin.outputs.ViewFilters
import com.pulumi.aws.resourceexplorer.kotlin.outputs.ViewIncludedProperty
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.resourceexplorer.kotlin.outputs.ViewFilters.Companion.toKotlin as viewFiltersToKotlin
import com.pulumi.aws.resourceexplorer.kotlin.outputs.ViewIncludedProperty.Companion.toKotlin as viewIncludedPropertyToKotlin

/**
 * Builder for [View].
 */
@PulumiTagMarker
public class ViewResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ViewArgs = ViewArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ViewArgsBuilder.() -> Unit) {
        val builder = ViewArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): View {
        val builtJavaResource = com.pulumi.aws.resourceexplorer.View(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return View(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a Resource Explorer view.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.resourceexplorer.Index("example", {type: "LOCAL"});
 * const exampleView = new aws.resourceexplorer.View("example", {
 *     name: "exampleview",
 *     filters: {
 *         filterString: "resourcetype:ec2:instance",
 *     },
 *     includedProperties: [{
 *         name: "tags",
 *     }],
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.resourceexplorer.Index("example", type="LOCAL")
 * example_view = aws.resourceexplorer.View("example",
 *     name="exampleview",
 *     filters={
 *         "filter_string": "resourcetype:ec2:instance",
 *     },
 *     included_properties=[{
 *         "name": "tags",
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ResourceExplorer.Index("example", new()
 *     {
 *         Type = "LOCAL",
 *     });
 *     var exampleView = new Aws.ResourceExplorer.View("example", new()
 *     {
 *         Name = "exampleview",
 *         Filters = new Aws.ResourceExplorer.Inputs.ViewFiltersArgs
 *         {
 *             FilterString = "resourcetype:ec2:instance",
 *         },
 *         IncludedProperties = new[]
 *         {
 *             new Aws.ResourceExplorer.Inputs.ViewIncludedPropertyArgs
 *             {
 *                 Name = "tags",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourceexplorer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := resourceexplorer.NewIndex(ctx, "example", &resourceexplorer.IndexArgs{
 * 			Type: pulumi.String("LOCAL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourceexplorer.NewView(ctx, "example", &resourceexplorer.ViewArgs{
 * 			Name: pulumi.String("exampleview"),
 * 			Filters: &resourceexplorer.ViewFiltersArgs{
 * 				FilterString: pulumi.String("resourcetype:ec2:instance"),
 * 			},
 * 			IncludedProperties: resourceexplorer.ViewIncludedPropertyArray{
 * 				&resourceexplorer.ViewIncludedPropertyArgs{
 * 					Name: pulumi.String("tags"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourceexplorer.Index;
 * import com.pulumi.aws.resourceexplorer.IndexArgs;
 * import com.pulumi.aws.resourceexplorer.View;
 * import com.pulumi.aws.resourceexplorer.ViewArgs;
 * import com.pulumi.aws.resourceexplorer.inputs.ViewFiltersArgs;
 * import com.pulumi.aws.resourceexplorer.inputs.ViewIncludedPropertyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .type("LOCAL")
 *             .build());
 *         var exampleView = new View("exampleView", ViewArgs.builder()
 *             .name("exampleview")
 *             .filters(ViewFiltersArgs.builder()
 *                 .filterString("resourcetype:ec2:instance")
 *                 .build())
 *             .includedProperties(ViewIncludedPropertyArgs.builder()
 *                 .name("tags")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:resourceexplorer:Index
 *     properties:
 *       type: LOCAL
 *   exampleView:
 *     type: aws:resourceexplorer:View
 *     name: example
 *     properties:
 *       name: exampleview
 *       filters:
 *         filterString: resourcetype:ec2:instance
 *       includedProperties:
 *         - name: tags
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Resource Explorer views using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:resourceexplorer/view:View example arn:aws:resource-explorer-2:us-west-2:123456789012:view/exampleview/e0914f6c-6c27-4b47-b5d4-6b28381a2421
 * ```
 */
public class View internal constructor(
    override val javaResource: com.pulumi.aws.resourceexplorer.View,
) : KotlinCustomResource(javaResource, ViewMapper) {
    /**
     * Amazon Resource Name (ARN) of the Resource Explorer view.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the view is the [_default view_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-about.html#manage-views-about-default) for the AWS Region. Default: `false`.
     */
    public val defaultView: Output<Boolean>
        get() = javaResource.defaultView().applyValue({ args0 -> args0 })

    /**
     * Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
     */
    public val filters: Output<ViewFilters>?
        get() = javaResource.filters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    viewFiltersToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    public val includedProperties: Output<List<ViewIncludedProperty>>?
        get() = javaResource.includedProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        viewIncludedPropertyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the view. The name must be no more than 64 characters long, and can include letters, digits, and the dash (-) character. The name must be unique within its AWS Region.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ViewMapper : ResourceMapper<View> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.resourceexplorer.View::class == javaResource::class

    override fun map(javaResource: Resource): View = View(
        javaResource as
            com.pulumi.aws.resourceexplorer.View,
    )
}

/**
 * @see [View].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [View].
 */
public suspend fun view(name: String, block: suspend ViewResourceBuilder.() -> Unit): View {
    val builder = ViewResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [View].
 * @param name The _unique_ name of the resulting resource.
 */
public fun view(name: String): View {
    val builder = ViewResourceBuilder()
    builder.name(name)
    return builder.build()
}
