@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin

import com.pulumi.aws.resourceexplorer.ViewArgs.builder
import com.pulumi.aws.resourceexplorer.kotlin.inputs.ViewFiltersArgs
import com.pulumi.aws.resourceexplorer.kotlin.inputs.ViewFiltersArgsBuilder
import com.pulumi.aws.resourceexplorer.kotlin.inputs.ViewIncludedPropertyArgs
import com.pulumi.aws.resourceexplorer.kotlin.inputs.ViewIncludedPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a Resource Explorer view.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.resourceexplorer.Index("example", {type: "LOCAL"});
 * const exampleView = new aws.resourceexplorer.View("example", {
 *     name: "exampleview",
 *     filters: {
 *         filterString: "resourcetype:ec2:instance",
 *     },
 *     includedProperties: [{
 *         name: "tags",
 *     }],
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.resourceexplorer.Index("example", type="LOCAL")
 * example_view = aws.resourceexplorer.View("example",
 *     name="exampleview",
 *     filters={
 *         "filter_string": "resourcetype:ec2:instance",
 *     },
 *     included_properties=[{
 *         "name": "tags",
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ResourceExplorer.Index("example", new()
 *     {
 *         Type = "LOCAL",
 *     });
 *     var exampleView = new Aws.ResourceExplorer.View("example", new()
 *     {
 *         Name = "exampleview",
 *         Filters = new Aws.ResourceExplorer.Inputs.ViewFiltersArgs
 *         {
 *             FilterString = "resourcetype:ec2:instance",
 *         },
 *         IncludedProperties = new[]
 *         {
 *             new Aws.ResourceExplorer.Inputs.ViewIncludedPropertyArgs
 *             {
 *                 Name = "tags",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourceexplorer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := resourceexplorer.NewIndex(ctx, "example", &resourceexplorer.IndexArgs{
 * 			Type: pulumi.String("LOCAL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourceexplorer.NewView(ctx, "example", &resourceexplorer.ViewArgs{
 * 			Name: pulumi.String("exampleview"),
 * 			Filters: &resourceexplorer.ViewFiltersArgs{
 * 				FilterString: pulumi.String("resourcetype:ec2:instance"),
 * 			},
 * 			IncludedProperties: resourceexplorer.ViewIncludedPropertyArray{
 * 				&resourceexplorer.ViewIncludedPropertyArgs{
 * 					Name: pulumi.String("tags"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourceexplorer.Index;
 * import com.pulumi.aws.resourceexplorer.IndexArgs;
 * import com.pulumi.aws.resourceexplorer.View;
 * import com.pulumi.aws.resourceexplorer.ViewArgs;
 * import com.pulumi.aws.resourceexplorer.inputs.ViewFiltersArgs;
 * import com.pulumi.aws.resourceexplorer.inputs.ViewIncludedPropertyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .type("LOCAL")
 *             .build());
 *         var exampleView = new View("exampleView", ViewArgs.builder()
 *             .name("exampleview")
 *             .filters(ViewFiltersArgs.builder()
 *                 .filterString("resourcetype:ec2:instance")
 *                 .build())
 *             .includedProperties(ViewIncludedPropertyArgs.builder()
 *                 .name("tags")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:resourceexplorer:Index
 *     properties:
 *       type: LOCAL
 *   exampleView:
 *     type: aws:resourceexplorer:View
 *     name: example
 *     properties:
 *       name: exampleview
 *       filters:
 *         filterString: resourcetype:ec2:instance
 *       includedProperties:
 *         - name: tags
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Resource Explorer views using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:resourceexplorer/view:View example arn:aws:resource-explorer-2:us-west-2:123456789012:view/exampleview/e0914f6c-6c27-4b47-b5d4-6b28381a2421
 * ```
 * @property defaultView Specifies whether the view is the [_default view_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-about.html#manage-views-about-default) for the AWS Region. Default: `false`.
 * @property filters Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
 * @property includedProperties Optional fields to be included in search results from this view. See Included Properties below for more details.
 * @property name The name of the view. The name must be no more than 64 characters long, and can include letters, digits, and the dash (-) character. The name must be unique within its AWS Region.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ViewArgs(
    public val defaultView: Output<Boolean>? = null,
    public val filters: Output<ViewFiltersArgs>? = null,
    public val includedProperties: Output<List<ViewIncludedPropertyArgs>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.resourceexplorer.ViewArgs> {
    override fun toJava(): com.pulumi.aws.resourceexplorer.ViewArgs =
        com.pulumi.aws.resourceexplorer.ViewArgs.builder()
            .defaultView(defaultView?.applyValue({ args0 -> args0 }))
            .filters(filters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .includedProperties(
                includedProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ViewArgs].
 */
@PulumiTagMarker
public class ViewArgsBuilder internal constructor() {
    private var defaultView: Output<Boolean>? = null

    private var filters: Output<ViewFiltersArgs>? = null

    private var includedProperties: Output<List<ViewIncludedPropertyArgs>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies whether the view is the [_default view_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-about.html#manage-views-about-default) for the AWS Region. Default: `false`.
     */
    @JvmName("jekwyqstaxjdwbpm")
    public suspend fun defaultView(`value`: Output<Boolean>) {
        this.defaultView = value
    }

    /**
     * @param value Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
     */
    @JvmName("uqpigqpcmlvucumj")
    public suspend fun filters(`value`: Output<ViewFiltersArgs>) {
        this.filters = value
    }

    /**
     * @param value Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("bbvjupmgenrgfeje")
    public suspend fun includedProperties(`value`: Output<List<ViewIncludedPropertyArgs>>) {
        this.includedProperties = value
    }

    @JvmName("luscvmpujqbuujcl")
    public suspend fun includedProperties(vararg values: Output<ViewIncludedPropertyArgs>) {
        this.includedProperties = Output.all(values.asList())
    }

    /**
     * @param values Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("nvsrontbgjbdyumc")
    public suspend fun includedProperties(values: List<Output<ViewIncludedPropertyArgs>>) {
        this.includedProperties = Output.all(values)
    }

    /**
     * @param value The name of the view. The name must be no more than 64 characters long, and can include letters, digits, and the dash (-) character. The name must be unique within its AWS Region.
     */
    @JvmName("lswvdaqlitcpmppk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xharpuvjtsvluxbe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether the view is the [_default view_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-about.html#manage-views-about-default) for the AWS Region. Default: `false`.
     */
    @JvmName("ucgxevmbkjmoxwce")
    public suspend fun defaultView(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultView = mapped
    }

    /**
     * @param value Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
     */
    @JvmName("ptftengjnippxvxc")
    public suspend fun filters(`value`: ViewFiltersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
     */
    @JvmName("uoqvijsvhtvpelra")
    public suspend fun filters(argument: suspend ViewFiltersArgsBuilder.() -> Unit) {
        val toBeMapped = ViewFiltersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param value Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("dajavjmtobinoato")
    public suspend fun includedProperties(`value`: List<ViewIncludedPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedProperties = mapped
    }

    /**
     * @param argument Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("kabyjpretgokicwd")
    public suspend fun includedProperties(argument: List<suspend ViewIncludedPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ViewIncludedPropertyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.includedProperties = mapped
    }

    /**
     * @param argument Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("ldiqlvoepvkvmhmg")
    public suspend fun includedProperties(vararg argument: suspend ViewIncludedPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ViewIncludedPropertyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.includedProperties = mapped
    }

    /**
     * @param argument Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("emfrrtdojnrvipmd")
    public suspend fun includedProperties(argument: suspend ViewIncludedPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ViewIncludedPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.includedProperties = mapped
    }

    /**
     * @param values Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("talwybgjduqiagmq")
    public suspend fun includedProperties(vararg values: ViewIncludedPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedProperties = mapped
    }

    /**
     * @param value The name of the view. The name must be no more than 64 characters long, and can include letters, digits, and the dash (-) character. The name must be unique within its AWS Region.
     */
    @JvmName("avwabdqbtmgjdppe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vsnsxihkncqxhvld")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qbxbrrctftejwmbt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ViewArgs = ViewArgs(
        defaultView = defaultView,
        filters = filters,
        includedProperties = includedProperties,
        name = name,
        tags = tags,
    )
}
