@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin.inputs

import com.pulumi.aws.resourceexplorer.inputs.SearchPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking Search.
 * @property queryString String that includes keywords and filters that specify the resources that you want to include in the results. For the complete syntax supported by the QueryString parameter, see Search query syntax reference for [Resource Explorer](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html). The search is completely case insensitive. You can specify an empty string to return all results up to the limit of 1,000 total results. The operation can return only the first 1,000 results. If the resource you want is not included, then use a different value for QueryString to refine the results.
 * The following arguments are optional:
 * @property viewArn Specifies the Amazon resource name (ARN) of the view to use for the query. If you don't specify a value for this parameter, then the operation automatically uses the default view for the AWS Region in which you called this operation. If the Region either doesn't have a default view or if you don't have permission to use the default view, then the operation fails with a `401 Unauthorized` exception.
 */
public data class SearchPlainArgs(
    public val queryString: String,
    public val viewArn: String? = null,
) : ConvertibleToJava<com.pulumi.aws.resourceexplorer.inputs.SearchPlainArgs> {
    override fun toJava(): com.pulumi.aws.resourceexplorer.inputs.SearchPlainArgs =
        com.pulumi.aws.resourceexplorer.inputs.SearchPlainArgs.builder()
            .queryString(queryString.let({ args0 -> args0 }))
            .viewArn(viewArn?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [SearchPlainArgs].
 */
@PulumiTagMarker
public class SearchPlainArgsBuilder internal constructor() {
    private var queryString: String? = null

    private var viewArn: String? = null

    /**
     * @param value String that includes keywords and filters that specify the resources that you want to include in the results. For the complete syntax supported by the QueryString parameter, see Search query syntax reference for [Resource Explorer](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html). The search is completely case insensitive. You can specify an empty string to return all results up to the limit of 1,000 total results. The operation can return only the first 1,000 results. If the resource you want is not included, then use a different value for QueryString to refine the results.
     * The following arguments are optional:
     */
    @JvmName("drnmjiguntldvpmc")
    public suspend fun queryString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.queryString = mapped
    }

    /**
     * @param value Specifies the Amazon resource name (ARN) of the view to use for the query. If you don't specify a value for this parameter, then the operation automatically uses the default view for the AWS Region in which you called this operation. If the Region either doesn't have a default view or if you don't have permission to use the default view, then the operation fails with a `401 Unauthorized` exception.
     */
    @JvmName("bbkrsadtnmsuvqej")
    public suspend fun viewArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.viewArn = mapped
    }

    internal fun build(): SearchPlainArgs = SearchPlainArgs(
        queryString = queryString ?: throw PulumiNullFieldException("queryString"),
        viewArn = viewArn,
    )
}
