@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin.inputs

import com.pulumi.aws.resourceexplorer.inputs.ViewFiltersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filterString The string that contains the search keywords, prefixes, and operators to control the results that can be returned by a search operation. For more details, see [Search query syntax](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html).
 */
public data class ViewFiltersArgs(
    public val filterString: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.resourceexplorer.inputs.ViewFiltersArgs> {
    override fun toJava(): com.pulumi.aws.resourceexplorer.inputs.ViewFiltersArgs =
        com.pulumi.aws.resourceexplorer.inputs.ViewFiltersArgs.builder()
            .filterString(filterString.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ViewFiltersArgs].
 */
@PulumiTagMarker
public class ViewFiltersArgsBuilder internal constructor() {
    private var filterString: Output<String>? = null

    /**
     * @param value The string that contains the search keywords, prefixes, and operators to control the results that can be returned by a search operation. For more details, see [Search query syntax](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html).
     */
    @JvmName("deemgsofrjeniudi")
    public suspend fun filterString(`value`: Output<String>) {
        this.filterString = value
    }

    /**
     * @param value The string that contains the search keywords, prefixes, and operators to control the results that can be returned by a search operation. For more details, see [Search query syntax](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html).
     */
    @JvmName("wbtaujbhxxlxcblh")
    public suspend fun filterString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterString = mapped
    }

    internal fun build(): ViewFiltersArgs = ViewFiltersArgs(
        filterString = filterString ?: throw PulumiNullFieldException("filterString"),
    )
}
