@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin.inputs

import com.pulumi.aws.resourceexplorer.inputs.ViewIncludedPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the property that is included in this view. Valid values: `tags`.
 */
public data class ViewIncludedPropertyArgs(
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.resourceexplorer.inputs.ViewIncludedPropertyArgs> {
    override fun toJava(): com.pulumi.aws.resourceexplorer.inputs.ViewIncludedPropertyArgs =
        com.pulumi.aws.resourceexplorer.inputs.ViewIncludedPropertyArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ViewIncludedPropertyArgs].
 */
@PulumiTagMarker
public class ViewIncludedPropertyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the property that is included in this view. Valid values: `tags`.
     */
    @JvmName("imfwsuccgcidrene")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the property that is included in this view. Valid values: `tags`.
     */
    @JvmName("fniyiaaxhqisbyuo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ViewIncludedPropertyArgs = ViewIncludedPropertyArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
