@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property arn Amazon resource name of resource.
 * @property lastReportedAt The date and time that the information about this resource property was last updated.
 * @property owningAccountId Amazon Web Services account that owns the resource.
 * @property properties Structure with additional type-specific details about the resource.  See `properties` below.
 * @property region Amazon Web Services Region in which the resource was created and exists.
 * @property resourceType Type of the resource.
 * @property service Amazon Web Service that owns the resource and is responsible for creating and updating it.
 */
public data class SearchResource(
    public val arn: String,
    public val lastReportedAt: String,
    public val owningAccountId: String,
    public val properties: List<SearchResourceProperty>,
    public val region: String,
    public val resourceType: String,
    public val service: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.resourceexplorer.outputs.SearchResource): SearchResource = SearchResource(
            arn = javaType.arn(),
            lastReportedAt = javaType.lastReportedAt(),
            owningAccountId = javaType.owningAccountId(),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.resourceexplorer.kotlin.outputs.SearchResourceProperty.Companion.toKotlin(args0)
                })
            }),
            region = javaType.region(),
            resourceType = javaType.resourceType(),
            service = javaType.service(),
        )
    }
}
