@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property complete Indicates whether the TotalResources value represents an exhaustive count of search results. If True, it indicates that the search was exhaustive. Every resource that matches the query was counted. If False, then the search reached the limit of 1,000 matching results, and stopped counting.
 * @property totalResources Number of resources that match the search query. This value can't exceed 1,000. If there are more than 1,000 resources that match the query, then only 1,000 are counted and the Complete field is set to false. We recommend that you refine your query to return a smaller number of results.
 */
public data class SearchResourceCount(
    public val complete: Boolean,
    public val totalResources: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.resourceexplorer.outputs.SearchResourceCount): SearchResourceCount = SearchResourceCount(
            complete = javaType.complete(),
            totalResources = javaType.totalResources(),
        )
    }
}
