@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by Search.
 * @property id Query String.
 * @property queryString
 * @property resourceCounts Number of resources that match the query. See `resource_count` below.
 * @property resources List of structures that describe the resources that match the query. See `resources` below.
 * @property viewArn
 */
public data class SearchResult(
    public val id: String,
    public val queryString: String,
    public val resourceCounts: List<SearchResourceCount>,
    public val resources: List<SearchResource>,
    public val viewArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.resourceexplorer.outputs.SearchResult): SearchResult = SearchResult(
            id = javaType.id(),
            queryString = javaType.queryString(),
            resourceCounts = javaType.resourceCounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.resourceexplorer.kotlin.outputs.SearchResourceCount.Companion.toKotlin(args0)
                })
            }),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.resourceexplorer.kotlin.outputs.SearchResource.Companion.toKotlin(args0)
                })
            }),
            viewArn = javaType.viewArn(),
        )
    }
}
