@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin

import com.pulumi.aws.resourcegroups.GroupArgs.builder
import com.pulumi.aws.resourcegroups.kotlin.inputs.GroupConfigurationArgs
import com.pulumi.aws.resourcegroups.kotlin.inputs.GroupConfigurationArgsBuilder
import com.pulumi.aws.resourcegroups.kotlin.inputs.GroupResourceQueryArgs
import com.pulumi.aws.resourcegroups.kotlin.inputs.GroupResourceQueryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Resource Group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.resourcegroups.Group("test", {
 *     name: "test-group",
 *     resourceQuery: {
 *         query: `{
 *   "ResourceTypeFilters": [
 *     "AWS::EC2::Instance"
 *   ],
 *   "TagFilters": [
 *     {
 *       "Key": "Stage",
 *       "Values": ["Test"]
 *     }
 *   ]
 * }
 * `,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.resourcegroups.Group("test",
 *     name="test-group",
 *     resource_query={
 *         "query": """{
 *   "ResourceTypeFilters": [
 *     "AWS::EC2::Instance"
 *   ],
 *   "TagFilters": [
 *     {
 *       "Key": "Stage",
 *       "Values": ["Test"]
 *     }
 *   ]
 * }
 * """,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.ResourceGroups.Group("test", new()
 *     {
 *         Name = "test-group",
 *         ResourceQuery = new Aws.ResourceGroups.Inputs.GroupResourceQueryArgs
 *         {
 *             Query = @"{
 *   ""ResourceTypeFilters"": [
 *     ""AWS::EC2::Instance""
 *   ],
 *   ""TagFilters"": [
 *     {
 *       ""Key"": ""Stage"",
 *       ""Values"": [""Test""]
 *     }
 *   ]
 * }
 * ",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourcegroups"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resourcegroups.NewGroup(ctx, "test", &resourcegroups.GroupArgs{
 * 			Name: pulumi.String("test-group"),
 * 			ResourceQuery: &resourcegroups.GroupResourceQueryArgs{
 * 				Query: pulumi.String(`{
 *   "ResourceTypeFilters": [
 *     "AWS::EC2::Instance"
 *   ],
 *   "TagFilters": [
 *     {
 *       "Key": "Stage",
 *       "Values": ["Test"]
 *     }
 *   ]
 * }
 * `),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourcegroups.Group;
 * import com.pulumi.aws.resourcegroups.GroupArgs;
 * import com.pulumi.aws.resourcegroups.inputs.GroupResourceQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Group("test", GroupArgs.builder()
 *             .name("test-group")
 *             .resourceQuery(GroupResourceQueryArgs.builder()
 *                 .query("""
 * {
 *   "ResourceTypeFilters": [
 *     "AWS::EC2::Instance"
 *   ],
 *   "TagFilters": [
 *     {
 *       "Key": "Stage",
 *       "Values": ["Test"]
 *     }
 *   ]
 * }
 *                 """)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:resourcegroups:Group
 *     properties:
 *       name: test-group
 *       resourceQuery:
 *         query: |
 *           {
 *             "ResourceTypeFilters": [
 *               "AWS::EC2::Instance"
 *             ],
 *             "TagFilters": [
 *               {
 *                 "Key": "Stage",
 *                 "Values": ["Test"]
 *               }
 *             ]
 *           }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import resource groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:resourcegroups/group:Group foo resource-group-name
 * ```
 * @property configurations A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
 * @property description A description of the resource group.
 * @property name The resource group's name. A resource group name can have a maximum of 127 characters, including letters, numbers, hyphens, dots, and underscores. The name cannot start with `AWS` or `aws`.
 * @property resourceQuery A `resource_query` block. Resource queries are documented below.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class GroupArgs(
    public val configurations: Output<List<GroupConfigurationArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceQuery: Output<GroupResourceQueryArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.resourcegroups.GroupArgs> {
    override fun toJava(): com.pulumi.aws.resourcegroups.GroupArgs =
        com.pulumi.aws.resourcegroups.GroupArgs.builder()
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceQuery(resourceQuery?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var configurations: Output<List<GroupConfigurationArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceQuery: Output<GroupResourceQueryArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("gajldjblakscheet")
    public suspend fun configurations(`value`: Output<List<GroupConfigurationArgs>>) {
        this.configurations = value
    }

    @JvmName("uadrrkrcstykqgfh")
    public suspend fun configurations(vararg values: Output<GroupConfigurationArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("knfufdaaktnnopay")
    public suspend fun configurations(values: List<Output<GroupConfigurationArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value A description of the resource group.
     */
    @JvmName("yiabnklawutqyipr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The resource group's name. A resource group name can have a maximum of 127 characters, including letters, numbers, hyphens, dots, and underscores. The name cannot start with `AWS` or `aws`.
     */
    @JvmName("xtjisajhgwecgtvg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A `resource_query` block. Resource queries are documented below.
     */
    @JvmName("brqtkbqdgdwvsorv")
    public suspend fun resourceQuery(`value`: Output<GroupResourceQueryArgs>) {
        this.resourceQuery = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aqbyipilmjatfgdp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("qkhdqowivheonujy")
    public suspend fun configurations(`value`: List<GroupConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("shxhkhoahbrlgoke")
    public suspend fun configurations(argument: List<suspend GroupConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("mdmgteccdivsgake")
    public suspend fun configurations(vararg argument: suspend GroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GroupConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("btjulvkxmtpcunsm")
    public suspend fun configurations(argument: suspend GroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GroupConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("jxntjcbvmvqiquaa")
    public suspend fun configurations(vararg values: GroupConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value A description of the resource group.
     */
    @JvmName("nxissmapocluijjb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The resource group's name. A resource group name can have a maximum of 127 characters, including letters, numbers, hyphens, dots, and underscores. The name cannot start with `AWS` or `aws`.
     */
    @JvmName("xjfktrcgvkinmmed")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A `resource_query` block. Resource queries are documented below.
     */
    @JvmName("vodbpeyldluhvqmm")
    public suspend fun resourceQuery(`value`: GroupResourceQueryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceQuery = mapped
    }

    /**
     * @param argument A `resource_query` block. Resource queries are documented below.
     */
    @JvmName("iquucalordstndbi")
    public suspend fun resourceQuery(argument: suspend GroupResourceQueryArgsBuilder.() -> Unit) {
        val toBeMapped = GroupResourceQueryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceQuery = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xgxoglcbulvqcrbw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tmlgqoebkrgimvnk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        configurations = configurations,
        description = description,
        name = name,
        resourceQuery = resourceQuery,
        tags = tags,
    )
}
