@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Resource].
 */
@PulumiTagMarker
public class ResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceArgs = ResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceArgsBuilder.() -> Unit) {
        val builder = ResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Resource {
        val builtJavaResource = com.pulumi.aws.resourcegroups.Resource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Resource(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Resource Groups Resource.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.DedicatedHost("example", {
 *     instanceFamily: "t3",
 *     availabilityZone: "us-east-1a",
 *     hostRecovery: "off",
 *     autoPlacement: "on",
 * });
 * const exampleGroup = new aws.resourcegroups.Group("example", {name: "example"});
 * const exampleResource = new aws.resourcegroups.Resource("example", {
 *     groupArn: exampleGroup.arn,
 *     resourceArn: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.DedicatedHost("example",
 *     instance_family="t3",
 *     availability_zone="us-east-1a",
 *     host_recovery="off",
 *     auto_placement="on")
 * example_group = aws.resourcegroups.Group("example", name="example")
 * example_resource = aws.resourcegroups.Resource("example",
 *     group_arn=example_group.arn,
 *     resource_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.DedicatedHost("example", new()
 *     {
 *         InstanceFamily = "t3",
 *         AvailabilityZone = "us-east-1a",
 *         HostRecovery = "off",
 *         AutoPlacement = "on",
 *     });
 *     var exampleGroup = new Aws.ResourceGroups.Group("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleResource = new Aws.ResourceGroups.Resource("example", new()
 *     {
 *         GroupArn = exampleGroup.Arn,
 *         ResourceArn = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourcegroups"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewDedicatedHost(ctx, "example", &ec2.DedicatedHostArgs{
 * 			InstanceFamily:   pulumi.String("t3"),
 * 			AvailabilityZone: pulumi.String("us-east-1a"),
 * 			HostRecovery:     pulumi.String("off"),
 * 			AutoPlacement:    pulumi.String("on"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGroup, err := resourcegroups.NewGroup(ctx, "example", &resourcegroups.GroupArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcegroups.NewResource(ctx, "example", &resourcegroups.ResourceArgs{
 * 			GroupArn:    exampleGroup.Arn,
 * 			ResourceArn: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DedicatedHost;
 * import com.pulumi.aws.ec2.DedicatedHostArgs;
 * import com.pulumi.aws.resourcegroups.Group;
 * import com.pulumi.aws.resourcegroups.GroupArgs;
 * import com.pulumi.aws.resourcegroups.Resource;
 * import com.pulumi.aws.resourcegroups.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DedicatedHost("example", DedicatedHostArgs.builder()
 *             .instanceFamily("t3")
 *             .availabilityZone("us-east-1a")
 *             .hostRecovery("off")
 *             .autoPlacement("on")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleResource = new Resource("exampleResource", ResourceArgs.builder()
 *             .groupArn(exampleGroup.arn())
 *             .resourceArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:DedicatedHost
 *     properties:
 *       instanceFamily: t3
 *       availabilityZone: us-east-1a
 *       hostRecovery: off
 *       autoPlacement: on
 *   exampleGroup:
 *     type: aws:resourcegroups:Group
 *     name: example
 *     properties:
 *       name: example
 *   exampleResource:
 *     type: aws:resourcegroups:Resource
 *     name: example
 *     properties:
 *       groupArn: ${exampleGroup.arn}
 *       resourceArn: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class Resource internal constructor(
    override val javaResource: com.pulumi.aws.resourcegroups.Resource,
) : KotlinCustomResource(javaResource, ResourceMapper) {
    /**
     * The name or the ARN of the resource group to add resources to.
     * The following arguments are optional:
     */
    public val groupArn: Output<String>
        get() = javaResource.groupArn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the resource to be added to the group.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The resource type of a resource, such as `AWS::EC2::Instance`.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })
}

public object ResourceMapper : ResourceMapper<Resource> {
    override fun supportsMappingOfType(javaResource: com.pulumi.resources.Resource): Boolean =
        com.pulumi.aws.resourcegroups.Resource::class == javaResource::class

    override fun map(javaResource: com.pulumi.resources.Resource): Resource = Resource(
        javaResource as
            com.pulumi.aws.resourcegroups.Resource,
    )
}

/**
 * @see [Resource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Resource].
 */
public suspend fun resource(name: String, block: suspend ResourceResourceBuilder.() -> Unit): Resource {
    val builder = ResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Resource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resource(name: String): Resource {
    val builder = ResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
