@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin

import com.pulumi.aws.resourcegroups.ResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Resource Groups Resource.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.DedicatedHost("example", {
 *     instanceFamily: "t3",
 *     availabilityZone: "us-east-1a",
 *     hostRecovery: "off",
 *     autoPlacement: "on",
 * });
 * const exampleGroup = new aws.resourcegroups.Group("example", {name: "example"});
 * const exampleResource = new aws.resourcegroups.Resource("example", {
 *     groupArn: exampleGroup.arn,
 *     resourceArn: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.DedicatedHost("example",
 *     instance_family="t3",
 *     availability_zone="us-east-1a",
 *     host_recovery="off",
 *     auto_placement="on")
 * example_group = aws.resourcegroups.Group("example", name="example")
 * example_resource = aws.resourcegroups.Resource("example",
 *     group_arn=example_group.arn,
 *     resource_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.DedicatedHost("example", new()
 *     {
 *         InstanceFamily = "t3",
 *         AvailabilityZone = "us-east-1a",
 *         HostRecovery = "off",
 *         AutoPlacement = "on",
 *     });
 *     var exampleGroup = new Aws.ResourceGroups.Group("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleResource = new Aws.ResourceGroups.Resource("example", new()
 *     {
 *         GroupArn = exampleGroup.Arn,
 *         ResourceArn = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourcegroups"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewDedicatedHost(ctx, "example", &ec2.DedicatedHostArgs{
 * 			InstanceFamily:   pulumi.String("t3"),
 * 			AvailabilityZone: pulumi.String("us-east-1a"),
 * 			HostRecovery:     pulumi.String("off"),
 * 			AutoPlacement:    pulumi.String("on"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGroup, err := resourcegroups.NewGroup(ctx, "example", &resourcegroups.GroupArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcegroups.NewResource(ctx, "example", &resourcegroups.ResourceArgs{
 * 			GroupArn:    exampleGroup.Arn,
 * 			ResourceArn: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DedicatedHost;
 * import com.pulumi.aws.ec2.DedicatedHostArgs;
 * import com.pulumi.aws.resourcegroups.Group;
 * import com.pulumi.aws.resourcegroups.GroupArgs;
 * import com.pulumi.aws.resourcegroups.Resource;
 * import com.pulumi.aws.resourcegroups.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DedicatedHost("example", DedicatedHostArgs.builder()
 *             .instanceFamily("t3")
 *             .availabilityZone("us-east-1a")
 *             .hostRecovery("off")
 *             .autoPlacement("on")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleResource = new Resource("exampleResource", ResourceArgs.builder()
 *             .groupArn(exampleGroup.arn())
 *             .resourceArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:DedicatedHost
 *     properties:
 *       instanceFamily: t3
 *       availabilityZone: us-east-1a
 *       hostRecovery: off
 *       autoPlacement: on
 *   exampleGroup:
 *     type: aws:resourcegroups:Group
 *     name: example
 *     properties:
 *       name: example
 *   exampleResource:
 *     type: aws:resourcegroups:Resource
 *     name: example
 *     properties:
 *       groupArn: ${exampleGroup.arn}
 *       resourceArn: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property groupArn The name or the ARN of the resource group to add resources to.
 * The following arguments are optional:
 * @property resourceArn The ARN of the resource to be added to the group.
 */
public data class ResourceArgs(
    public val groupArn: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.resourcegroups.ResourceArgs> {
    override fun toJava(): com.pulumi.aws.resourcegroups.ResourceArgs =
        com.pulumi.aws.resourcegroups.ResourceArgs.builder()
            .groupArn(groupArn?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceArgs].
 */
@PulumiTagMarker
public class ResourceArgsBuilder internal constructor() {
    private var groupArn: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value The name or the ARN of the resource group to add resources to.
     * The following arguments are optional:
     */
    @JvmName("lpxdwjoafugswbrk")
    public suspend fun groupArn(`value`: Output<String>) {
        this.groupArn = value
    }

    /**
     * @param value The ARN of the resource to be added to the group.
     */
    @JvmName("jmwfhxdqunokcgnd")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The name or the ARN of the resource group to add resources to.
     * The following arguments are optional:
     */
    @JvmName("xostijtusarvfvkn")
    public suspend fun groupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupArn = mapped
    }

    /**
     * @param value The ARN of the resource to be added to the group.
     */
    @JvmName("iroikjhmswlwbonv")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourceArgs = ResourceArgs(
        groupArn = groupArn,
        resourceArn = resourceArn,
    )
}
