@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin.inputs

import com.pulumi.aws.resourcegroups.inputs.GroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property parameters A collection of parameters for this group configuration item. See below for details.
 * @property type Specifies the type of group configuration item.
 */
public data class GroupConfigurationArgs(
    public val parameters: Output<List<GroupConfigurationParameterArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.resourcegroups.inputs.GroupConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.resourcegroups.inputs.GroupConfigurationArgs =
        com.pulumi.aws.resourcegroups.inputs.GroupConfigurationArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupConfigurationArgs].
 */
@PulumiTagMarker
public class GroupConfigurationArgsBuilder internal constructor() {
    private var parameters: Output<List<GroupConfigurationParameterArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value A collection of parameters for this group configuration item. See below for details.
     */
    @JvmName("yvpxxlufelfukhru")
    public suspend fun parameters(`value`: Output<List<GroupConfigurationParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("rqienlgbimtgcmsm")
    public suspend fun parameters(vararg values: Output<GroupConfigurationParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values A collection of parameters for this group configuration item. See below for details.
     */
    @JvmName("urwfkhqkuppdrewb")
    public suspend fun parameters(values: List<Output<GroupConfigurationParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Specifies the type of group configuration item.
     */
    @JvmName("mebytpqxcvnwvflt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A collection of parameters for this group configuration item. See below for details.
     */
    @JvmName("lvvdibkuogcnuvph")
    public suspend fun parameters(`value`: List<GroupConfigurationParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument A collection of parameters for this group configuration item. See below for details.
     */
    @JvmName("pfrlmprxxwdsrxux")
    public suspend fun parameters(argument: List<suspend GroupConfigurationParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupConfigurationParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A collection of parameters for this group configuration item. See below for details.
     */
    @JvmName("gckvksnfygherdgy")
    public suspend fun parameters(vararg argument: suspend GroupConfigurationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GroupConfigurationParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A collection of parameters for this group configuration item. See below for details.
     */
    @JvmName("jbqjwyqdbiliqihu")
    public suspend fun parameters(argument: suspend GroupConfigurationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GroupConfigurationParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values A collection of parameters for this group configuration item. See below for details.
     */
    @JvmName("yewygekdubokssug")
    public suspend fun parameters(vararg values: GroupConfigurationParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Specifies the type of group configuration item.
     */
    @JvmName("yomipjybwlygtcfk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GroupConfigurationArgs = GroupConfigurationArgs(
        parameters = parameters,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
