@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property parameters A collection of parameters for this group configuration item. See below for details.
 * @property type Specifies the type of group configuration item.
 */
public data class GroupConfiguration(
    public val parameters: List<GroupConfigurationParameter>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.resourcegroups.outputs.GroupConfiguration): GroupConfiguration = GroupConfiguration(
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.resourcegroups.kotlin.outputs.GroupConfigurationParameter.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
