@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroupstaggingapi.kotlin

import com.pulumi.aws.resourcegroupstaggingapi.ResourcegroupstaggingapiFunctions.getResourcesPlain
import com.pulumi.aws.resourcegroupstaggingapi.kotlin.inputs.GetResourcesPlainArgs
import com.pulumi.aws.resourcegroupstaggingapi.kotlin.inputs.GetResourcesPlainArgsBuilder
import com.pulumi.aws.resourcegroupstaggingapi.kotlin.inputs.GetResourcesTagFilter
import com.pulumi.aws.resourcegroupstaggingapi.kotlin.outputs.GetResourcesResult
import com.pulumi.aws.resourcegroupstaggingapi.kotlin.outputs.GetResourcesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object ResourcegroupstaggingapiFunctions {
    /**
     * Provides details about resource tagging.
     * ## Example Usage
     * ### Get All Resource Tag Mappings
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.resourcegroupstaggingapi.getResources({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.resourcegroupstaggingapi.get_resources()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.ResourceGroupsTaggingApi.GetResources.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourcegroupstaggingapi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := resourcegroupstaggingapi.GetResources(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.resourcegroupstaggingapi.ResourcegroupstaggingapiFunctions;
     * import com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = ResourcegroupstaggingapiFunctions.getResources();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:resourcegroupstaggingapi:getResources
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Filter By Tag Key and Value
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.resourcegroupstaggingapi.getResources({
     *     tagFilters: [{
     *         key: "tag-key",
     *         values: [
     *             "tag-value-1",
     *             "tag-value-2",
     *         ],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.resourcegroupstaggingapi.get_resources(tag_filters=[{
     *     "key": "tag-key",
     *     "values": [
     *         "tag-value-1",
     *         "tag-value-2",
     *     ],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.ResourceGroupsTaggingApi.GetResources.Invoke(new()
     *     {
     *         TagFilters = new[]
     *         {
     *             new Aws.ResourceGroupsTaggingApi.Inputs.GetResourcesTagFilterInputArgs
     *             {
     *                 Key = "tag-key",
     *                 Values = new[]
     *                 {
     *                     "tag-value-1",
     *                     "tag-value-2",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourcegroupstaggingapi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := resourcegroupstaggingapi.GetResources(ctx, &resourcegroupstaggingapi.GetResourcesArgs{
     * 			TagFilters: []resourcegroupstaggingapi.GetResourcesTagFilter{
     * 				{
     * 					Key: "tag-key",
     * 					Values: []string{
     * 						"tag-value-1",
     * 						"tag-value-2",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.resourcegroupstaggingapi.ResourcegroupstaggingapiFunctions;
     * import com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = ResourcegroupstaggingapiFunctions.getResources(GetResourcesArgs.builder()
     *             .tagFilters(GetResourcesTagFilterArgs.builder()
     *                 .key("tag-key")
     *                 .values(
     *                     "tag-value-1",
     *                     "tag-value-2")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:resourcegroupstaggingapi:getResources
     *       Arguments:
     *         tagFilters:
     *           - key: tag-key
     *             values:
     *               - tag-value-1
     *               - tag-value-2
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Filter By Resource Type
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.resourcegroupstaggingapi.getResources({
     *     resourceTypeFilters: ["ec2:instance"],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.resourcegroupstaggingapi.get_resources(resource_type_filters=["ec2:instance"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.ResourceGroupsTaggingApi.GetResources.Invoke(new()
     *     {
     *         ResourceTypeFilters = new[]
     *         {
     *             "ec2:instance",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/resourcegroupstaggingapi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := resourcegroupstaggingapi.GetResources(ctx, &resourcegroupstaggingapi.GetResourcesArgs{
     * 			ResourceTypeFilters: []string{
     * 				"ec2:instance",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.resourcegroupstaggingapi.ResourcegroupstaggingapiFunctions;
     * import com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = ResourcegroupstaggingapiFunctions.getResources(GetResourcesArgs.builder()
     *             .resourceTypeFilters("ec2:instance")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:resourcegroupstaggingapi:getResources
     *       Arguments:
     *         resourceTypeFilters:
     *           - ec2:instance
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResources.
     * @return A collection of values returned by getResources.
     */
    public suspend fun getResources(argument: GetResourcesPlainArgs): GetResourcesResult =
        toKotlin(getResourcesPlain(argument.toJava()).await())

    /**
     * @see [getResources].
     * @param excludeCompliantResources Specifies whether to exclude resources that are compliant with the tag policy. You can use this parameter only if the `include_compliance_details` argument is also set to `true`.
     * @param includeComplianceDetails Specifies whether to include details regarding the compliance with the effective tag policy.
     * @param resourceArnLists Specifies a list of ARNs of resources for which you want to retrieve tag data. Conflicts with `filter`.
     * @param resourceTypeFilters Constraints on the resources that you want returned. The format of each resource type is `service:resourceType`. For example, specifying a resource type of `ec2` returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of `ec2:instance` returns only EC2 instances.
     * @param tagFilters Specifies a list of Tag Filters (keys and values) to restrict the output to only those resources that have the specified tag and, if included, the specified value. See Tag Filter below. Conflicts with `resource_arn_list`.
     * @return A collection of values returned by getResources.
     */
    public suspend fun getResources(
        excludeCompliantResources: Boolean? = null,
        includeComplianceDetails: Boolean? = null,
        resourceArnLists: List<String>? = null,
        resourceTypeFilters: List<String>? = null,
        tagFilters: List<GetResourcesTagFilter>? = null,
    ): GetResourcesResult {
        val argument = GetResourcesPlainArgs(
            excludeCompliantResources = excludeCompliantResources,
            includeComplianceDetails = includeComplianceDetails,
            resourceArnLists = resourceArnLists,
            resourceTypeFilters = resourceTypeFilters,
            tagFilters = tagFilters,
        )
        return toKotlin(getResourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [getResources].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;resourcegroupstaggingapi&#46;kotlin&#46;inputs&#46;GetResourcesPlainArgs].
     * @return A collection of values returned by getResources.
     */
    public suspend fun getResources(argument: suspend GetResourcesPlainArgsBuilder.() -> Unit): GetResourcesResult {
        val builder = GetResourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getResourcesPlain(builtArgument.toJava()).await())
    }
}
