@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroupstaggingapi.kotlin.inputs

import com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesTagFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key One part of a key-value pair that makes up a tag.
 * @property values Optional part of a key-value pair that make up a tag.
 */
public data class GetResourcesTagFilter(
    public val key: String,
    public val values: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesTagFilter> {
    override fun toJava(): com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesTagFilter =
        com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesTagFilter.builder()
            .key(key.let({ args0 -> args0 }))
            .values(values?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetResourcesTagFilter].
 */
@PulumiTagMarker
public class GetResourcesTagFilterBuilder internal constructor() {
    private var key: String? = null

    private var values: List<String>? = null

    /**
     * @param value One part of a key-value pair that makes up a tag.
     */
    @JvmName("mxrpufkswaauxgpq")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value Optional part of a key-value pair that make up a tag.
     */
    @JvmName("nfdrdawndsqprhmn")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Optional part of a key-value pair that make up a tag.
     */
    @JvmName("yqsijtvfbqyrlgkq")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetResourcesTagFilter = GetResourcesTagFilter(
        key = key ?: throw PulumiNullFieldException("key"),
        values = values,
    )
}
