@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroupstaggingapi.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property complianceDetails List of objects with information that shows whether a resource is compliant with the effective tag policy, including details on any noncompliant tag keys.
 * @property resourceArn ARN of the resource.
 * @property tags Map of tags assigned to the resource.
 */
public data class GetResourcesResourceTagMappingList(
    public val complianceDetails: List<GetResourcesResourceTagMappingListComplianceDetail>,
    public val resourceArn: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.resourcegroupstaggingapi.outputs.GetResourcesResourceTagMappingList): GetResourcesResourceTagMappingList = GetResourcesResourceTagMappingList(
            complianceDetails = javaType.complianceDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.resourcegroupstaggingapi.kotlin.outputs.GetResourcesResourceTagMappingListComplianceDetail.Companion.toKotlin(args0)
                })
            }),
            resourceArn = javaType.resourceArn(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
