@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroupstaggingapi.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property complianceStatus Whether the resource is compliant.
 * * `keys_with_noncompliant_values ` - Set of tag keys with non-compliant tag values.
 * * `non_compliant_keys ` - Set of non-compliant tag keys.
 * @property keysWithNoncompliantValues
 * @property nonCompliantKeys
 */
public data class GetResourcesResourceTagMappingListComplianceDetail(
    public val complianceStatus: Boolean,
    public val keysWithNoncompliantValues: List<String>,
    public val nonCompliantKeys: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.resourcegroupstaggingapi.outputs.GetResourcesResourceTagMappingListComplianceDetail): GetResourcesResourceTagMappingListComplianceDetail =
            GetResourcesResourceTagMappingListComplianceDetail(
                complianceStatus = javaType.complianceStatus(),
                keysWithNoncompliantValues = javaType.keysWithNoncompliantValues().map({ args0 -> args0 }),
                nonCompliantKeys = javaType.nonCompliantKeys().map({ args0 -> args0 }),
            )
    }
}
