@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroupstaggingapi.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key One part of a key-value pair that makes up a tag.
 * @property values Optional part of a key-value pair that make up a tag.
 */
public data class GetResourcesTagFilter(
    public val key: String,
    public val values: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.resourcegroupstaggingapi.outputs.GetResourcesTagFilter): GetResourcesTagFilter = GetResourcesTagFilter(
            key = javaType.key(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
