@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rolesanywhere.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Profile].
 */
@PulumiTagMarker
public class ProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProfileArgs = ProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProfileArgsBuilder.() -> Unit) {
        val builder = ProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Profile {
        val builtJavaResource = com.pulumi.aws.rolesanywhere.Profile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Profile(builtJavaResource)
    }
}

/**
 * Resource for managing a Roles Anywhere Profile.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.iam.Role("test", {
 *     name: "test",
 *     path: "/",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: [
 *                 "sts:AssumeRole",
 *                 "sts:TagSession",
 *                 "sts:SetSourceIdentity",
 *             ],
 *             Principal: {
 *                 Service: "rolesanywhere.amazonaws.com",
 *             },
 *             Effect: "Allow",
 *             Sid: "",
 *         }],
 *     }),
 * });
 * const testProfile = new aws.rolesanywhere.Profile("test", {
 *     name: "example",
 *     roleArns: [test&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * test = aws.iam.Role("test",
 *     name="test",
 *     path="/",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": [
 *                 "sts:AssumeRole",
 *                 "sts:TagSession",
 *                 "sts:SetSourceIdentity",
 *             ],
 *             "Principal": {
 *                 "Service": "rolesanywhere.amazonaws.com",
 *             },
 *             "Effect": "Allow",
 *             "Sid": "",
 *         }],
 *     }))
 * test_profile = aws.rolesanywhere.Profile("test",
 *     name="example",
 *     role_arns=[test&#46;arn])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Iam.Role("test", new()
 *     {
 *         Name = "test",
 *         Path = "/",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "sts:AssumeRole",
 *                         "sts:TagSession",
 *                         "sts:SetSourceIdentity",
 *                     },
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "rolesanywhere.amazonaws.com",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                 },
 *             },
 *         }),
 *     });
 *     var testProfile = new Aws.RolesAnywhere.Profile("test", new()
 *     {
 *         Name = "example",
 *         RoleArns = new[]
 *         {
 *             test.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rolesanywhere"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"sts:AssumeRole",
 * 						"sts:TagSession",
 * 						"sts:SetSourceIdentity",
 * 					},
 * 					"Principal": map[string]interface{}{
 * 						"Service": "rolesanywhere.amazonaws.com",
 * 					},
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		test, err := iam.NewRole(ctx, "test", &iam.RoleArgs{
 * 			Name:             pulumi.String("test"),
 * 			Path:             pulumi.String("/"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rolesanywhere.NewProfile(ctx, "test", &rolesanywhere.ProfileArgs{
 * 			Name: pulumi.String("example"),
 * 			RoleArns: pulumi.StringArray{
 * 				test.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.rolesanywhere.Profile;
 * import com.pulumi.aws.rolesanywhere.ProfileArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Role("test", RoleArgs.builder()
 *             .name("test")
 *             .path("/")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "sts:AssumeRole",
 *                             "sts:TagSession",
 *                             "sts:SetSourceIdentity"
 *                         )),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "rolesanywhere.amazonaws.com")
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", "")
 *                     )))
 *                 )))
 *             .build());
 *         var testProfile = new Profile("testProfile", ProfileArgs.builder()
 *             .name("example")
 *             .roleArns(test.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:iam:Role
 *     properties:
 *       name: test
 *       path: /
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - sts:AssumeRole
 *                 - sts:TagSession
 *                 - sts:SetSourceIdentity
 *               Principal:
 *                 Service: rolesanywhere.amazonaws.com
 *               Effect: Allow
 *               Sid:
 *   testProfile:
 *     type: aws:rolesanywhere:Profile
 *     name: test
 *     properties:
 *       name: example
 *       roleArns:
 *         - ${test.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_rolesanywhere_profile` using its `id`. For example:
 * ```sh
 * $ pulumi import aws:rolesanywhere/profile:Profile example db138a85-8925-4f9f-a409-08231233cacf
 * ```
 */
public class Profile internal constructor(
    override val javaResource: com.pulumi.aws.rolesanywhere.Profile,
) : KotlinCustomResource(javaResource, ProfileMapper) {
    /**
     * Amazon Resource Name (ARN) of the Profile
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The number of seconds the vended session credentials are valid for. Defaults to 3600.
     */
    public val durationSeconds: Output<Int>
        get() = javaResource.durationSeconds().applyValue({ args0 -> args0 })

    /**
     * Whether or not the Profile is enabled.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of managed policy ARNs that apply to the vended session credentials.
     */
    public val managedPolicyArns: Output<List<String>>?
        get() = javaResource.managedPolicyArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name of the Profile.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies whether instance properties are required in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile.
     */
    public val requireInstanceProperties: Output<Boolean>?
        get() = javaResource.requireInstanceProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of IAM roles that this profile can assume
     */
    public val roleArns: Output<List<String>>
        get() = javaResource.roleArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A session policy that applies to the trust boundary of the vended session credentials.
     */
    public val sessionPolicy: Output<String>?
        get() = javaResource.sessionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ProfileMapper : ResourceMapper<Profile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rolesanywhere.Profile::class == javaResource::class

    override fun map(javaResource: Resource): Profile = Profile(
        javaResource as
            com.pulumi.aws.rolesanywhere.Profile,
    )
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Profile].
 */
public suspend fun profile(name: String, block: suspend ProfileResourceBuilder.() -> Unit): Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun profile(name: String): Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
