@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rolesanywhere.kotlin

import com.pulumi.aws.rolesanywhere.ProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a Roles Anywhere Profile.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.iam.Role("test", {
 *     name: "test",
 *     path: "/",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: [
 *                 "sts:AssumeRole",
 *                 "sts:TagSession",
 *                 "sts:SetSourceIdentity",
 *             ],
 *             Principal: {
 *                 Service: "rolesanywhere.amazonaws.com",
 *             },
 *             Effect: "Allow",
 *             Sid: "",
 *         }],
 *     }),
 * });
 * const testProfile = new aws.rolesanywhere.Profile("test", {
 *     name: "example",
 *     roleArns: [test&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * test = aws.iam.Role("test",
 *     name="test",
 *     path="/",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": [
 *                 "sts:AssumeRole",
 *                 "sts:TagSession",
 *                 "sts:SetSourceIdentity",
 *             ],
 *             "Principal": {
 *                 "Service": "rolesanywhere.amazonaws.com",
 *             },
 *             "Effect": "Allow",
 *             "Sid": "",
 *         }],
 *     }))
 * test_profile = aws.rolesanywhere.Profile("test",
 *     name="example",
 *     role_arns=[test&#46;arn])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Iam.Role("test", new()
 *     {
 *         Name = "test",
 *         Path = "/",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "sts:AssumeRole",
 *                         "sts:TagSession",
 *                         "sts:SetSourceIdentity",
 *                     },
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "rolesanywhere.amazonaws.com",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                 },
 *             },
 *         }),
 *     });
 *     var testProfile = new Aws.RolesAnywhere.Profile("test", new()
 *     {
 *         Name = "example",
 *         RoleArns = new[]
 *         {
 *             test.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rolesanywhere"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"sts:AssumeRole",
 * 						"sts:TagSession",
 * 						"sts:SetSourceIdentity",
 * 					},
 * 					"Principal": map[string]interface{}{
 * 						"Service": "rolesanywhere.amazonaws.com",
 * 					},
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		test, err := iam.NewRole(ctx, "test", &iam.RoleArgs{
 * 			Name:             pulumi.String("test"),
 * 			Path:             pulumi.String("/"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rolesanywhere.NewProfile(ctx, "test", &rolesanywhere.ProfileArgs{
 * 			Name: pulumi.String("example"),
 * 			RoleArns: pulumi.StringArray{
 * 				test.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.rolesanywhere.Profile;
 * import com.pulumi.aws.rolesanywhere.ProfileArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Role("test", RoleArgs.builder()
 *             .name("test")
 *             .path("/")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "sts:AssumeRole",
 *                             "sts:TagSession",
 *                             "sts:SetSourceIdentity"
 *                         )),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "rolesanywhere.amazonaws.com")
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", "")
 *                     )))
 *                 )))
 *             .build());
 *         var testProfile = new Profile("testProfile", ProfileArgs.builder()
 *             .name("example")
 *             .roleArns(test.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:iam:Role
 *     properties:
 *       name: test
 *       path: /
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - sts:AssumeRole
 *                 - sts:TagSession
 *                 - sts:SetSourceIdentity
 *               Principal:
 *                 Service: rolesanywhere.amazonaws.com
 *               Effect: Allow
 *               Sid:
 *   testProfile:
 *     type: aws:rolesanywhere:Profile
 *     name: test
 *     properties:
 *       name: example
 *       roleArns:
 *         - ${test.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_rolesanywhere_profile` using its `id`. For example:
 * ```sh
 * $ pulumi import aws:rolesanywhere/profile:Profile example db138a85-8925-4f9f-a409-08231233cacf
 * ```
 * @property durationSeconds The number of seconds the vended session credentials are valid for. Defaults to 3600.
 * @property enabled Whether or not the Profile is enabled.
 * @property managedPolicyArns A list of managed policy ARNs that apply to the vended session credentials.
 * @property name The name of the Profile.
 * @property requireInstanceProperties Specifies whether instance properties are required in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile.
 * @property roleArns A list of IAM roles that this profile can assume
 * @property sessionPolicy A session policy that applies to the trust boundary of the vended session credentials.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ProfileArgs(
    public val durationSeconds: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
    public val managedPolicyArns: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val requireInstanceProperties: Output<Boolean>? = null,
    public val roleArns: Output<List<String>>? = null,
    public val sessionPolicy: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rolesanywhere.ProfileArgs> {
    override fun toJava(): com.pulumi.aws.rolesanywhere.ProfileArgs =
        com.pulumi.aws.rolesanywhere.ProfileArgs.builder()
            .durationSeconds(durationSeconds?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .managedPolicyArns(managedPolicyArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .requireInstanceProperties(requireInstanceProperties?.applyValue({ args0 -> args0 }))
            .roleArns(roleArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sessionPolicy(sessionPolicy?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProfileArgs].
 */
@PulumiTagMarker
public class ProfileArgsBuilder internal constructor() {
    private var durationSeconds: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    private var managedPolicyArns: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var requireInstanceProperties: Output<Boolean>? = null

    private var roleArns: Output<List<String>>? = null

    private var sessionPolicy: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The number of seconds the vended session credentials are valid for. Defaults to 3600.
     */
    @JvmName("mribkmiwdxghybnp")
    public suspend fun durationSeconds(`value`: Output<Int>) {
        this.durationSeconds = value
    }

    /**
     * @param value Whether or not the Profile is enabled.
     */
    @JvmName("mxwfkrwolwjswnxo")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A list of managed policy ARNs that apply to the vended session credentials.
     */
    @JvmName("jbobmwudyxtuetgs")
    public suspend fun managedPolicyArns(`value`: Output<List<String>>) {
        this.managedPolicyArns = value
    }

    @JvmName("csvxudbwgllcbbut")
    public suspend fun managedPolicyArns(vararg values: Output<String>) {
        this.managedPolicyArns = Output.all(values.asList())
    }

    /**
     * @param values A list of managed policy ARNs that apply to the vended session credentials.
     */
    @JvmName("nqkmxcqyrpgufyjr")
    public suspend fun managedPolicyArns(values: List<Output<String>>) {
        this.managedPolicyArns = Output.all(values)
    }

    /**
     * @param value The name of the Profile.
     */
    @JvmName("lkxvtmythqetpmyx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether instance properties are required in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile.
     */
    @JvmName("wqdnysuvfyyqscav")
    public suspend fun requireInstanceProperties(`value`: Output<Boolean>) {
        this.requireInstanceProperties = value
    }

    /**
     * @param value A list of IAM roles that this profile can assume
     */
    @JvmName("fgsmaosmsvfxbhtq")
    public suspend fun roleArns(`value`: Output<List<String>>) {
        this.roleArns = value
    }

    @JvmName("krnnhvcounmjnash")
    public suspend fun roleArns(vararg values: Output<String>) {
        this.roleArns = Output.all(values.asList())
    }

    /**
     * @param values A list of IAM roles that this profile can assume
     */
    @JvmName("twcnvtgtonsyjgha")
    public suspend fun roleArns(values: List<Output<String>>) {
        this.roleArns = Output.all(values)
    }

    /**
     * @param value A session policy that applies to the trust boundary of the vended session credentials.
     */
    @JvmName("wvmxfbdvjvwwvahs")
    public suspend fun sessionPolicy(`value`: Output<String>) {
        this.sessionPolicy = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("acheplqxwpxnoxeh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of seconds the vended session credentials are valid for. Defaults to 3600.
     */
    @JvmName("hqjjxtaidxxwaish")
    public suspend fun durationSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.durationSeconds = mapped
    }

    /**
     * @param value Whether or not the Profile is enabled.
     */
    @JvmName("huyoltvlujabhdnr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A list of managed policy ARNs that apply to the vended session credentials.
     */
    @JvmName("kosbjwkpflxalmnl")
    public suspend fun managedPolicyArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPolicyArns = mapped
    }

    /**
     * @param values A list of managed policy ARNs that apply to the vended session credentials.
     */
    @JvmName("creesirwwghfiqai")
    public suspend fun managedPolicyArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedPolicyArns = mapped
    }

    /**
     * @param value The name of the Profile.
     */
    @JvmName("hjwadyslfmuehtwd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether instance properties are required in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile.
     */
    @JvmName("bpijlnkrsscjcbhm")
    public suspend fun requireInstanceProperties(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireInstanceProperties = mapped
    }

    /**
     * @param value A list of IAM roles that this profile can assume
     */
    @JvmName("xyskyhugntmrmuui")
    public suspend fun roleArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArns = mapped
    }

    /**
     * @param values A list of IAM roles that this profile can assume
     */
    @JvmName("txtegnvgvswpisdh")
    public suspend fun roleArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArns = mapped
    }

    /**
     * @param value A session policy that applies to the trust boundary of the vended session credentials.
     */
    @JvmName("dcawfvjrdadqudql")
    public suspend fun sessionPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionPolicy = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("urauavlbgpbxjxfa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("miseyblxulyvoijy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProfileArgs = ProfileArgs(
        durationSeconds = durationSeconds,
        enabled = enabled,
        managedPolicyArns = managedPolicyArns,
        name = name,
        requireInstanceProperties = requireInstanceProperties,
        roleArns = roleArns,
        sessionPolicy = sessionPolicy,
        tags = tags,
    )
}
