@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rolesanywhere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property sourceData The data denoting the source of trust, documented below
 * @property sourceType The type of the source of trust. Must be either `AWS_ACM_PCA` or `CERTIFICATE_BUNDLE`.
 */
public data class TrustAnchorSource(
    public val sourceData: TrustAnchorSourceSourceData,
    public val sourceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rolesanywhere.outputs.TrustAnchorSource): TrustAnchorSource = TrustAnchorSource(
            sourceData = javaType.sourceData().let({ args0 ->
                com.pulumi.aws.rolesanywhere.kotlin.outputs.TrustAnchorSourceSourceData.Companion.toKotlin(args0)
            }),
            sourceType = javaType.sourceType(),
        )
    }
}
