@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CidrCollection].
 */
@PulumiTagMarker
public class CidrCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CidrCollectionArgs = CidrCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CidrCollectionArgsBuilder.() -> Unit) {
        val builder = CidrCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CidrCollection {
        val builtJavaResource = com.pulumi.aws.route53.CidrCollection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CidrCollection(builtJavaResource)
    }
}

/**
 * Provides a Route53 CIDR collection resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.CidrCollection("example", {name: "collection-1"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.CidrCollection("example", name="collection-1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.CidrCollection("example", new()
 *     {
 *         Name = "collection-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewCidrCollection(ctx, "example", &route53.CidrCollectionArgs{
 * 			Name: pulumi.String("collection-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.CidrCollection;
 * import com.pulumi.aws.route53.CidrCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CidrCollection("example", CidrCollectionArgs.builder()
 *             .name("collection-1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:CidrCollection
 *     properties:
 *       name: collection-1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CIDR collections using their ID. For example:
 * ```sh
 * $ pulumi import aws:route53/cidrCollection:CidrCollection example 9ac32814-3e67-0932-6048-8d779cc6f511
 * ```
 */
public class CidrCollection internal constructor(
    override val javaResource: com.pulumi.aws.route53.CidrCollection,
) : KotlinCustomResource(javaResource, CidrCollectionMapper) {
    /**
     * The Amazon Resource Name (ARN) of the CIDR collection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Unique name for the CIDR collection.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The lastest version of the CIDR collection.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object CidrCollectionMapper : ResourceMapper<CidrCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.CidrCollection::class == javaResource::class

    override fun map(javaResource: Resource): CidrCollection = CidrCollection(
        javaResource as
            com.pulumi.aws.route53.CidrCollection,
    )
}

/**
 * @see [CidrCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CidrCollection].
 */
public suspend fun cidrCollection(
    name: String,
    block: suspend CidrCollectionResourceBuilder.() -> Unit,
): CidrCollection {
    val builder = CidrCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CidrCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cidrCollection(name: String): CidrCollection {
    val builder = CidrCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
