@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.CidrCollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route53 CIDR collection resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.CidrCollection("example", {name: "collection-1"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.CidrCollection("example", name="collection-1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.CidrCollection("example", new()
 *     {
 *         Name = "collection-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewCidrCollection(ctx, "example", &route53.CidrCollectionArgs{
 * 			Name: pulumi.String("collection-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.CidrCollection;
 * import com.pulumi.aws.route53.CidrCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CidrCollection("example", CidrCollectionArgs.builder()
 *             .name("collection-1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:CidrCollection
 *     properties:
 *       name: collection-1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CIDR collections using their ID. For example:
 * ```sh
 * $ pulumi import aws:route53/cidrCollection:CidrCollection example 9ac32814-3e67-0932-6048-8d779cc6f511
 * ```
 * @property name Unique name for the CIDR collection.
 */
public data class CidrCollectionArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.CidrCollectionArgs> {
    override fun toJava(): com.pulumi.aws.route53.CidrCollectionArgs =
        com.pulumi.aws.route53.CidrCollectionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CidrCollectionArgs].
 */
@PulumiTagMarker
public class CidrCollectionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Unique name for the CIDR collection.
     */
    @JvmName("pjfosddnsmllsfai")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Unique name for the CIDR collection.
     */
    @JvmName("oymddnsfxcwlgayn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CidrCollectionArgs = CidrCollectionArgs(
        name = name,
    )
}
