@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.CidrLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Route53 CIDR location resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.CidrCollection("example", {name: "collection-1"});
 * const exampleCidrLocation = new aws.route53.CidrLocation("example", {
 *     cidrCollectionId: example.id,
 *     name: "office",
 *     cidrBlocks: [
 *         "200.5.3.0/24",
 *         "200.6.3.0/24",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.CidrCollection("example", name="collection-1")
 * example_cidr_location = aws.route53.CidrLocation("example",
 *     cidr_collection_id=example.id,
 *     name="office",
 *     cidr_blocks=[
 *         "200.5.3.0/24",
 *         "200.6.3.0/24",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.CidrCollection("example", new()
 *     {
 *         Name = "collection-1",
 *     });
 *     var exampleCidrLocation = new Aws.Route53.CidrLocation("example", new()
 *     {
 *         CidrCollectionId = example.Id,
 *         Name = "office",
 *         CidrBlocks = new[]
 *         {
 *             "200.5.3.0/24",
 *             "200.6.3.0/24",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := route53.NewCidrCollection(ctx, "example", &route53.CidrCollectionArgs{
 * 			Name: pulumi.String("collection-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewCidrLocation(ctx, "example", &route53.CidrLocationArgs{
 * 			CidrCollectionId: example.ID(),
 * 			Name:             pulumi.String("office"),
 * 			CidrBlocks: pulumi.StringArray{
 * 				pulumi.String("200.5.3.0/24"),
 * 				pulumi.String("200.6.3.0/24"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.CidrCollection;
 * import com.pulumi.aws.route53.CidrCollectionArgs;
 * import com.pulumi.aws.route53.CidrLocation;
 * import com.pulumi.aws.route53.CidrLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CidrCollection("example", CidrCollectionArgs.builder()
 *             .name("collection-1")
 *             .build());
 *         var exampleCidrLocation = new CidrLocation("exampleCidrLocation", CidrLocationArgs.builder()
 *             .cidrCollectionId(example.id())
 *             .name("office")
 *             .cidrBlocks(
 *                 "200.5.3.0/24",
 *                 "200.6.3.0/24")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:CidrCollection
 *     properties:
 *       name: collection-1
 *   exampleCidrLocation:
 *     type: aws:route53:CidrLocation
 *     name: example
 *     properties:
 *       cidrCollectionId: ${example.id}
 *       name: office
 *       cidrBlocks:
 *         - 200.5.3.0/24
 *         - 200.6.3.0/24
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CIDR locations using their the CIDR collection ID and location name. For example:
 * ```sh
 * $ pulumi import aws:route53/cidrLocation:CidrLocation example 9ac32814-3e67-0932-6048-8d779cc6f511,office
 * ```
 * @property cidrBlocks CIDR blocks for the location.
 * @property cidrCollectionId The ID of the CIDR collection to update.
 * @property name Name for the CIDR location.
 */
public data class CidrLocationArgs(
    public val cidrBlocks: Output<List<String>>? = null,
    public val cidrCollectionId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.CidrLocationArgs> {
    override fun toJava(): com.pulumi.aws.route53.CidrLocationArgs =
        com.pulumi.aws.route53.CidrLocationArgs.builder()
            .cidrBlocks(cidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cidrCollectionId(cidrCollectionId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CidrLocationArgs].
 */
@PulumiTagMarker
public class CidrLocationArgsBuilder internal constructor() {
    private var cidrBlocks: Output<List<String>>? = null

    private var cidrCollectionId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value CIDR blocks for the location.
     */
    @JvmName("tximtxohocwppaig")
    public suspend fun cidrBlocks(`value`: Output<List<String>>) {
        this.cidrBlocks = value
    }

    @JvmName("fgpttmxncjpcfmcr")
    public suspend fun cidrBlocks(vararg values: Output<String>) {
        this.cidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values CIDR blocks for the location.
     */
    @JvmName("obcdhbecuaplriex")
    public suspend fun cidrBlocks(values: List<Output<String>>) {
        this.cidrBlocks = Output.all(values)
    }

    /**
     * @param value The ID of the CIDR collection to update.
     */
    @JvmName("xdpftjluvhnbmhid")
    public suspend fun cidrCollectionId(`value`: Output<String>) {
        this.cidrCollectionId = value
    }

    /**
     * @param value Name for the CIDR location.
     */
    @JvmName("syqrsdaegxedxuqm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value CIDR blocks for the location.
     */
    @JvmName("mmwwsabfbwkqfxoo")
    public suspend fun cidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlocks = mapped
    }

    /**
     * @param values CIDR blocks for the location.
     */
    @JvmName("faroplatetwpmewk")
    public suspend fun cidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrBlocks = mapped
    }

    /**
     * @param value The ID of the CIDR collection to update.
     */
    @JvmName("uoapifiwmgntadyv")
    public suspend fun cidrCollectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrCollectionId = mapped
    }

    /**
     * @param value Name for the CIDR location.
     */
    @JvmName("wmdeagogmrntwikp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CidrLocationArgs = CidrLocationArgs(
        cidrBlocks = cidrBlocks,
        cidrCollectionId = cidrCollectionId,
        name = name,
    )
}
