@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DelegationSet].
 */
@PulumiTagMarker
public class DelegationSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DelegationSetArgs = DelegationSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DelegationSetArgsBuilder.() -> Unit) {
        val builder = DelegationSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DelegationSet {
        val builtJavaResource = com.pulumi.aws.route53.DelegationSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DelegationSet(builtJavaResource)
    }
}

/**
 * Provides a [Route53 Delegation Set](https://docs.aws.amazon.com/Route53/latest/APIReference/API-actions-by-function.html#actions-by-function-reusable-delegation-sets) resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.route53.DelegationSet("main", {referenceName: "DynDNS"});
 * const primary = new aws.route53.Zone("primary", {
 *     name: "mydomain.com",
 *     delegationSetId: main.id,
 * });
 * const secondary = new aws.route53.Zone("secondary", {
 *     name: "coolcompany.io",
 *     delegationSetId: main.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.route53.DelegationSet("main", reference_name="DynDNS")
 * primary = aws.route53.Zone("primary",
 *     name="mydomain.com",
 *     delegation_set_id=main.id)
 * secondary = aws.route53.Zone("secondary",
 *     name="coolcompany.io",
 *     delegation_set_id=main.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Route53.DelegationSet("main", new()
 *     {
 *         ReferenceName = "DynDNS",
 *     });
 *     var primary = new Aws.Route53.Zone("primary", new()
 *     {
 *         Name = "mydomain.com",
 *         DelegationSetId = main.Id,
 *     });
 *     var secondary = new Aws.Route53.Zone("secondary", new()
 *     {
 *         Name = "coolcompany.io",
 *         DelegationSetId = main.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := route53.NewDelegationSet(ctx, "main", &route53.DelegationSetArgs{
 * 			ReferenceName: pulumi.String("DynDNS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewZone(ctx, "primary", &route53.ZoneArgs{
 * 			Name:            pulumi.String("mydomain.com"),
 * 			DelegationSetId: main.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewZone(ctx, "secondary", &route53.ZoneArgs{
 * 			Name:            pulumi.String("coolcompany.io"),
 * 			DelegationSetId: main.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.DelegationSet;
 * import com.pulumi.aws.route53.DelegationSetArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new DelegationSet("main", DelegationSetArgs.builder()
 *             .referenceName("DynDNS")
 *             .build());
 *         var primary = new Zone("primary", ZoneArgs.builder()
 *             .name("mydomain.com")
 *             .delegationSetId(main.id())
 *             .build());
 *         var secondary = new Zone("secondary", ZoneArgs.builder()
 *             .name("coolcompany.io")
 *             .delegationSetId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:route53:DelegationSet
 *     properties:
 *       referenceName: DynDNS
 *   primary:
 *     type: aws:route53:Zone
 *     properties:
 *       name: mydomain.com
 *       delegationSetId: ${main.id}
 *   secondary:
 *     type: aws:route53:Zone
 *     properties:
 *       name: coolcompany.io
 *       delegationSetId: ${main.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Delegation Sets using the delegation set `id`. For example:
 * ```sh
 * $ pulumi import aws:route53/delegationSet:DelegationSet set1 N1PA6795SAMPLE
 * ```
 */
public class DelegationSet internal constructor(
    override val javaResource: com.pulumi.aws.route53.DelegationSet,
) : KotlinCustomResource(javaResource, DelegationSetMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Delegation Set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A list of authoritative name servers for the hosted zone
     * (effectively a list of NS records).
     */
    public val nameServers: Output<List<String>>
        get() = javaResource.nameServers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * This is a reference name used in Caller Reference
     * (helpful for identifying single delegation set amongst others)
     */
    public val referenceName: Output<String>?
        get() = javaResource.referenceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DelegationSetMapper : ResourceMapper<DelegationSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.DelegationSet::class == javaResource::class

    override fun map(javaResource: Resource): DelegationSet = DelegationSet(
        javaResource as
            com.pulumi.aws.route53.DelegationSet,
    )
}

/**
 * @see [DelegationSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DelegationSet].
 */
public suspend fun delegationSet(
    name: String,
    block: suspend DelegationSetResourceBuilder.() -> Unit,
): DelegationSet {
    val builder = DelegationSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DelegationSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun delegationSet(name: String): DelegationSet {
    val builder = DelegationSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
