@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.DelegationSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a [Route53 Delegation Set](https://docs.aws.amazon.com/Route53/latest/APIReference/API-actions-by-function.html#actions-by-function-reusable-delegation-sets) resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.route53.DelegationSet("main", {referenceName: "DynDNS"});
 * const primary = new aws.route53.Zone("primary", {
 *     name: "mydomain.com",
 *     delegationSetId: main.id,
 * });
 * const secondary = new aws.route53.Zone("secondary", {
 *     name: "coolcompany.io",
 *     delegationSetId: main.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.route53.DelegationSet("main", reference_name="DynDNS")
 * primary = aws.route53.Zone("primary",
 *     name="mydomain.com",
 *     delegation_set_id=main.id)
 * secondary = aws.route53.Zone("secondary",
 *     name="coolcompany.io",
 *     delegation_set_id=main.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Route53.DelegationSet("main", new()
 *     {
 *         ReferenceName = "DynDNS",
 *     });
 *     var primary = new Aws.Route53.Zone("primary", new()
 *     {
 *         Name = "mydomain.com",
 *         DelegationSetId = main.Id,
 *     });
 *     var secondary = new Aws.Route53.Zone("secondary", new()
 *     {
 *         Name = "coolcompany.io",
 *         DelegationSetId = main.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := route53.NewDelegationSet(ctx, "main", &route53.DelegationSetArgs{
 * 			ReferenceName: pulumi.String("DynDNS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewZone(ctx, "primary", &route53.ZoneArgs{
 * 			Name:            pulumi.String("mydomain.com"),
 * 			DelegationSetId: main.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewZone(ctx, "secondary", &route53.ZoneArgs{
 * 			Name:            pulumi.String("coolcompany.io"),
 * 			DelegationSetId: main.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.DelegationSet;
 * import com.pulumi.aws.route53.DelegationSetArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new DelegationSet("main", DelegationSetArgs.builder()
 *             .referenceName("DynDNS")
 *             .build());
 *         var primary = new Zone("primary", ZoneArgs.builder()
 *             .name("mydomain.com")
 *             .delegationSetId(main.id())
 *             .build());
 *         var secondary = new Zone("secondary", ZoneArgs.builder()
 *             .name("coolcompany.io")
 *             .delegationSetId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:route53:DelegationSet
 *     properties:
 *       referenceName: DynDNS
 *   primary:
 *     type: aws:route53:Zone
 *     properties:
 *       name: mydomain.com
 *       delegationSetId: ${main.id}
 *   secondary:
 *     type: aws:route53:Zone
 *     properties:
 *       name: coolcompany.io
 *       delegationSetId: ${main.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Delegation Sets using the delegation set `id`. For example:
 * ```sh
 * $ pulumi import aws:route53/delegationSet:DelegationSet set1 N1PA6795SAMPLE
 * ```
 * @property referenceName This is a reference name used in Caller Reference
 * (helpful for identifying single delegation set amongst others)
 */
public data class DelegationSetArgs(
    public val referenceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.DelegationSetArgs> {
    override fun toJava(): com.pulumi.aws.route53.DelegationSetArgs =
        com.pulumi.aws.route53.DelegationSetArgs.builder()
            .referenceName(referenceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelegationSetArgs].
 */
@PulumiTagMarker
public class DelegationSetArgsBuilder internal constructor() {
    private var referenceName: Output<String>? = null

    /**
     * @param value This is a reference name used in Caller Reference
     * (helpful for identifying single delegation set amongst others)
     */
    @JvmName("qdpbbngwprlqmkax")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value This is a reference name used in Caller Reference
     * (helpful for identifying single delegation set amongst others)
     */
    @JvmName("ebfcarddpnqxqvjy")
    public suspend fun referenceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    internal fun build(): DelegationSetArgs = DelegationSetArgs(
        referenceName = referenceName,
    )
}
