@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.kotlin.outputs.RecordAlias
import com.pulumi.aws.route53.kotlin.outputs.RecordCidrRoutingPolicy
import com.pulumi.aws.route53.kotlin.outputs.RecordFailoverRoutingPolicy
import com.pulumi.aws.route53.kotlin.outputs.RecordGeolocationRoutingPolicy
import com.pulumi.aws.route53.kotlin.outputs.RecordGeoproximityRoutingPolicy
import com.pulumi.aws.route53.kotlin.outputs.RecordLatencyRoutingPolicy
import com.pulumi.aws.route53.kotlin.outputs.RecordWeightedRoutingPolicy
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.route53.kotlin.outputs.RecordAlias.Companion.toKotlin as recordAliasToKotlin
import com.pulumi.aws.route53.kotlin.outputs.RecordCidrRoutingPolicy.Companion.toKotlin as recordCidrRoutingPolicyToKotlin
import com.pulumi.aws.route53.kotlin.outputs.RecordFailoverRoutingPolicy.Companion.toKotlin as recordFailoverRoutingPolicyToKotlin
import com.pulumi.aws.route53.kotlin.outputs.RecordGeolocationRoutingPolicy.Companion.toKotlin as recordGeolocationRoutingPolicyToKotlin
import com.pulumi.aws.route53.kotlin.outputs.RecordGeoproximityRoutingPolicy.Companion.toKotlin as recordGeoproximityRoutingPolicyToKotlin
import com.pulumi.aws.route53.kotlin.outputs.RecordLatencyRoutingPolicy.Companion.toKotlin as recordLatencyRoutingPolicyToKotlin
import com.pulumi.aws.route53.kotlin.outputs.RecordWeightedRoutingPolicy.Companion.toKotlin as recordWeightedRoutingPolicyToKotlin

/**
 * Builder for [Record].
 */
@PulumiTagMarker
public class RecordResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RecordArgs = RecordArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RecordArgsBuilder.() -> Unit) {
        val builder = RecordArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Record {
        val builtJavaResource = com.pulumi.aws.route53.Record(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Record(builtJavaResource)
    }
}

/**
 * Provides a Route53 record resource.
 * ## Example Usage
 * ### Simple routing policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const www = new aws.route53.Record("www", {
 *     zoneId: primary.zoneId,
 *     name: "www.example.com",
 *     type: aws.route53.RecordType.A,
 *     ttl: 300,
 *     records: [lb&#46;publicIp],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * www = aws.route53.Record("www",
 *     zone_id=primary["zoneId"],
 *     name="www.example.com",
 *     type=aws.route53.RecordType.A,
 *     ttl=300,
 *     records=[lb["publicIp"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var www = new Aws.Route53.Record("www", new()
 *     {
 *         ZoneId = primary.ZoneId,
 *         Name = "www.example.com",
 *         Type = Aws.Route53.RecordType.A,
 *         Ttl = 300,
 *         Records = new[]
 *         {
 *             lb.PublicIp,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewRecord(ctx, "www", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(primary.ZoneId),
 * 			Name:   pulumi.String("www.example.com"),
 * 			Type:   pulumi.String(route53.RecordTypeA),
 * 			Ttl:    pulumi.Int(300),
 * 			Records: pulumi.StringArray{
 * 				lb.PublicIp,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var www = new Record("www", RecordArgs.builder()
 *             .zoneId(primary.zoneId())
 *             .name("www.example.com")
 *             .type("A")
 *             .ttl(300)
 *             .records(lb.publicIp())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   www:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${primary.zoneId}
 *       name: www.example.com
 *       type: A
 *       ttl: 300
 *       records:
 *         - ${lb.publicIp}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Weighted routing policy
 * Other routing policies are configured similarly. See [Amazon Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html) for details.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const www_dev = new aws.route53.Record("www-dev", {
 *     zoneId: primary.zoneId,
 *     name: "www",
 *     type: aws.route53.RecordType.CNAME,
 *     ttl: 5,
 *     weightedRoutingPolicies: [{
 *         weight: 10,
 *     }],
 *     setIdentifier: "dev",
 *     records: ["dev&#46;example&#46;com"],
 * });
 * const www_live = new aws.route53.Record("www-live", {
 *     zoneId: primary.zoneId,
 *     name: "www",
 *     type: aws.route53.RecordType.CNAME,
 *     ttl: 5,
 *     weightedRoutingPolicies: [{
 *         weight: 90,
 *     }],
 *     setIdentifier: "live",
 *     records: ["live&#46;example&#46;com"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * www_dev = aws.route53.Record("www-dev",
 *     zone_id=primary["zoneId"],
 *     name="www",
 *     type=aws.route53.RecordType.CNAME,
 *     ttl=5,
 *     weighted_routing_policies=[{
 *         "weight": 10,
 *     }],
 *     set_identifier="dev",
 *     records=["dev&#46;example&#46;com"])
 * www_live = aws.route53.Record("www-live",
 *     zone_id=primary["zoneId"],
 *     name="www",
 *     type=aws.route53.RecordType.CNAME,
 *     ttl=5,
 *     weighted_routing_policies=[{
 *         "weight": 90,
 *     }],
 *     set_identifier="live",
 *     records=["live&#46;example&#46;com"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var www_dev = new Aws.Route53.Record("www-dev", new()
 *     {
 *         ZoneId = primary.ZoneId,
 *         Name = "www",
 *         Type = Aws.Route53.RecordType.CNAME,
 *         Ttl = 5,
 *         WeightedRoutingPolicies = new[]
 *         {
 *             new Aws.Route53.Inputs.RecordWeightedRoutingPolicyArgs
 *             {
 *                 Weight = 10,
 *             },
 *         },
 *         SetIdentifier = "dev",
 *         Records = new[]
 *         {
 *             "dev.example.com",
 *         },
 *     });
 *     var www_live = new Aws.Route53.Record("www-live", new()
 *     {
 *         ZoneId = primary.ZoneId,
 *         Name = "www",
 *         Type = Aws.Route53.RecordType.CNAME,
 *         Ttl = 5,
 *         WeightedRoutingPolicies = new[]
 *         {
 *             new Aws.Route53.Inputs.RecordWeightedRoutingPolicyArgs
 *             {
 *                 Weight = 90,
 *             },
 *         },
 *         SetIdentifier = "live",
 *         Records = new[]
 *         {
 *             "live.example.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewRecord(ctx, "www-dev", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(primary.ZoneId),
 * 			Name:   pulumi.String("www"),
 * 			Type:   pulumi.String(route53.RecordTypeCNAME),
 * 			Ttl:    pulumi.Int(5),
 * 			WeightedRoutingPolicies: route53.RecordWeightedRoutingPolicyArray{
 * 				&route53.RecordWeightedRoutingPolicyArgs{
 * 					Weight: pulumi.Int(10),
 * 				},
 * 			},
 * 			SetIdentifier: pulumi.String("dev"),
 * 			Records: pulumi.StringArray{
 * 				pulumi.String("dev.example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewRecord(ctx, "www-live", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(primary.ZoneId),
 * 			Name:   pulumi.String("www"),
 * 			Type:   pulumi.String(route53.RecordTypeCNAME),
 * 			Ttl:    pulumi.Int(5),
 * 			WeightedRoutingPolicies: route53.RecordWeightedRoutingPolicyArray{
 * 				&route53.RecordWeightedRoutingPolicyArgs{
 * 					Weight: pulumi.Int(90),
 * 				},
 * 			},
 * 			SetIdentifier: pulumi.String("live"),
 * 			Records: pulumi.StringArray{
 * 				pulumi.String("live.example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordWeightedRoutingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var www_dev = new Record("www-dev", RecordArgs.builder()
 *             .zoneId(primary.zoneId())
 *             .name("www")
 *             .type("CNAME")
 *             .ttl(5)
 *             .weightedRoutingPolicies(RecordWeightedRoutingPolicyArgs.builder()
 *                 .weight(10)
 *                 .build())
 *             .setIdentifier("dev")
 *             .records("dev.example.com")
 *             .build());
 *         var www_live = new Record("www-live", RecordArgs.builder()
 *             .zoneId(primary.zoneId())
 *             .name("www")
 *             .type("CNAME")
 *             .ttl(5)
 *             .weightedRoutingPolicies(RecordWeightedRoutingPolicyArgs.builder()
 *                 .weight(90)
 *                 .build())
 *             .setIdentifier("live")
 *             .records("live.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   www-dev:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${primary.zoneId}
 *       name: www
 *       type: CNAME
 *       ttl: 5
 *       weightedRoutingPolicies:
 *         - weight: 10
 *       setIdentifier: dev
 *       records:
 *         - dev.example.com
 *   www-live:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${primary.zoneId}
 *       name: www
 *       type: CNAME
 *       ttl: 5
 *       weightedRoutingPolicies:
 *         - weight: 90
 *       setIdentifier: live
 *       records:
 *         - live.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Geoproximity routing policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const www = new aws.route53.Record("www", {
 *     zoneId: primary.zoneId,
 *     name: "www.example.com",
 *     type: aws.route53.RecordType.CNAME,
 *     ttl: 300,
 *     geoproximityRoutingPolicy: {
 *         coordinates: [{
 *             latitude: "49.22",
 *             longitude: "-74.01",
 *         }],
 *     },
 *     setIdentifier: "dev",
 *     records: ["dev&#46;example&#46;com"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * www = aws.route53.Record("www",
 *     zone_id=primary["zoneId"],
 *     name="www.example.com",
 *     type=aws.route53.RecordType.CNAME,
 *     ttl=300,
 *     geoproximity_routing_policy={
 *         "coordinates": [{
 *             "latitude": "49.22",
 *             "longitude": "-74.01",
 *         }],
 *     },
 *     set_identifier="dev",
 *     records=["dev&#46;example&#46;com"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var www = new Aws.Route53.Record("www", new()
 *     {
 *         ZoneId = primary.ZoneId,
 *         Name = "www.example.com",
 *         Type = Aws.Route53.RecordType.CNAME,
 *         Ttl = 300,
 *         GeoproximityRoutingPolicy = new Aws.Route53.Inputs.RecordGeoproximityRoutingPolicyArgs
 *         {
 *             Coordinates = new[]
 *             {
 *                 new Aws.Route53.Inputs.RecordGeoproximityRoutingPolicyCoordinateArgs
 *                 {
 *                     Latitude = "49.22",
 *                     Longitude = "-74.01",
 *                 },
 *             },
 *         },
 *         SetIdentifier = "dev",
 *         Records = new[]
 *         {
 *             "dev.example.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewRecord(ctx, "www", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(primary.ZoneId),
 * 			Name:   pulumi.String("www.example.com"),
 * 			Type:   pulumi.String(route53.RecordTypeCNAME),
 * 			Ttl:    pulumi.Int(300),
 * 			GeoproximityRoutingPolicy: &route53.RecordGeoproximityRoutingPolicyArgs{
 * 				Coordinates: route53.RecordGeoproximityRoutingPolicyCoordinateArray{
 * 					&route53.RecordGeoproximityRoutingPolicyCoordinateArgs{
 * 						Latitude:  pulumi.String("49.22"),
 * 						Longitude: pulumi.String("-74.01"),
 * 					},
 * 				},
 * 			},
 * 			SetIdentifier: pulumi.String("dev"),
 * 			Records: pulumi.StringArray{
 * 				pulumi.String("dev.example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordGeoproximityRoutingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var www = new Record("www", RecordArgs.builder()
 *             .zoneId(primary.zoneId())
 *             .name("www.example.com")
 *             .type("CNAME")
 *             .ttl(300)
 *             .geoproximityRoutingPolicy(RecordGeoproximityRoutingPolicyArgs.builder()
 *                 .coordinates(RecordGeoproximityRoutingPolicyCoordinateArgs.builder()
 *                     .latitude("49.22")
 *                     .longitude("-74.01")
 *                     .build())
 *                 .build())
 *             .setIdentifier("dev")
 *             .records("dev.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   www:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${primary.zoneId}
 *       name: www.example.com
 *       type: CNAME
 *       ttl: 300
 *       geoproximityRoutingPolicy:
 *         coordinates:
 *           - latitude: '49.22'
 *             longitude: '-74.01'
 *       setIdentifier: dev
 *       records:
 *         - dev.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Alias record
 * See [related part of Amazon Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-choosing-alias-non-alias.html)
 * to understand differences between alias and non-alias records.
 * TTL for all alias records is [60 seconds](https://aws.amazon.com/route53/faqs/#dns_failover_do_i_need_to_adjust),
 * you cannot change this, therefore `ttl` has to be omitted in alias records.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.elb.LoadBalancer("main", {
 *     name: "foobar-elb",
 *     availabilityZones: ["us-east-1c"],
 *     listeners: [{
 *         instancePort: 80,
 *         instanceProtocol: "http",
 *         lbPort: 80,
 *         lbProtocol: "http",
 *     }],
 * });
 * const www = new aws.route53.Record("www", {
 *     zoneId: primary.zoneId,
 *     name: "example.com",
 *     type: aws.route53.RecordType.A,
 *     aliases: [{
 *         name: main.dnsName,
 *         zoneId: main.zoneId,
 *         evaluateTargetHealth: true,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.elb.LoadBalancer("main",
 *     name="foobar-elb",
 *     availability_zones=["us-east-1c"],
 *     listeners=[{
 *         "instance_port": 80,
 *         "instance_protocol": "http",
 *         "lb_port": 80,
 *         "lb_protocol": "http",
 *     }])
 * www = aws.route53.Record("www",
 *     zone_id=primary["zoneId"],
 *     name="example.com",
 *     type=aws.route53.RecordType.A,
 *     aliases=[{
 *         "name": main.dns_name,
 *         "zone_id": main.zone_id,
 *         "evaluate_target_health": True,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Elb.LoadBalancer("main", new()
 *     {
 *         Name = "foobar-elb",
 *         AvailabilityZones = new[]
 *         {
 *             "us-east-1c",
 *         },
 *         Listeners = new[]
 *         {
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 80,
 *                 InstanceProtocol = "http",
 *                 LbPort = 80,
 *                 LbProtocol = "http",
 *             },
 *         },
 *     });
 *     var www = new Aws.Route53.Record("www", new()
 *     {
 *         ZoneId = primary.ZoneId,
 *         Name = "example.com",
 *         Type = Aws.Route53.RecordType.A,
 *         Aliases = new[]
 *         {
 *             new Aws.Route53.Inputs.RecordAliasArgs
 *             {
 *                 Name = main.DnsName,
 *                 ZoneId = main.ZoneId,
 *                 EvaluateTargetHealth = true,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elb"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := elb.NewLoadBalancer(ctx, "main", &elb.LoadBalancerArgs{
 * 			Name: pulumi.String("foobar-elb"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-east-1c"),
 * 			},
 * 			Listeners: elb.LoadBalancerListenerArray{
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(80),
 * 					InstanceProtocol: pulumi.String("http"),
 * 					LbPort:           pulumi.Int(80),
 * 					LbProtocol:       pulumi.String("http"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewRecord(ctx, "www", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(primary.ZoneId),
 * 			Name:   pulumi.String("example.com"),
 * 			Type:   pulumi.String(route53.RecordTypeA),
 * 			Aliases: route53.RecordAliasArray{
 * 				&route53.RecordAliasArgs{
 * 					Name:                 main.DnsName,
 * 					ZoneId:               main.ZoneId,
 * 					EvaluateTargetHealth: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new LoadBalancer("main", LoadBalancerArgs.builder()
 *             .name("foobar-elb")
 *             .availabilityZones("us-east-1c")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(80)
 *                 .instanceProtocol("http")
 *                 .lbPort(80)
 *                 .lbProtocol("http")
 *                 .build())
 *             .build());
 *         var www = new Record("www", RecordArgs.builder()
 *             .zoneId(primary.zoneId())
 *             .name("example.com")
 *             .type("A")
 *             .aliases(RecordAliasArgs.builder()
 *                 .name(main.dnsName())
 *                 .zoneId(main.zoneId())
 *                 .evaluateTargetHealth(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:elb:LoadBalancer
 *     properties:
 *       name: foobar-elb
 *       availabilityZones:
 *         - us-east-1c
 *       listeners:
 *         - instancePort: 80
 *           instanceProtocol: http
 *           lbPort: 80
 *           lbProtocol: http
 *   www:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${primary.zoneId}
 *       name: example.com
 *       type: A
 *       aliases:
 *         - name: ${main.dnsName}
 *           zoneId: ${main.zoneId}
 *           evaluateTargetHealth: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### NS and SOA Record Management
 * When creating Route 53 zones, the `NS` and `SOA` records for the zone are automatically created. Enabling the `allow_overwrite` argument will allow managing these records in a single deployment without the requirement for `import`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.Zone("example", {name: "test.example.com"});
 * const exampleRecord = new aws.route53.Record("example", {
 *     allowOverwrite: true,
 *     name: "test.example.com",
 *     ttl: 172800,
 *     type: aws.route53.RecordType.NS,
 *     zoneId: example.zoneId,
 *     records: [
 *         example.nameServers[0],
 *         example.nameServers[1],
 *         example.nameServers[2],
 *         example.nameServers[3],
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.Zone("example", name="test.example.com")
 * example_record = aws.route53.Record("example",
 *     allow_overwrite=True,
 *     name="test.example.com",
 *     ttl=172800,
 *     type=aws.route53.RecordType.NS,
 *     zone_id=example.zone_id,
 *     records=[
 *         example.name_servers[0],
 *         example.name_servers[1],
 *         example.name_servers[2],
 *         example.name_servers[3],
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.Zone("example", new()
 *     {
 *         Name = "test.example.com",
 *     });
 *     var exampleRecord = new Aws.Route53.Record("example", new()
 *     {
 *         AllowOverwrite = true,
 *         Name = "test.example.com",
 *         Ttl = 172800,
 *         Type = Aws.Route53.RecordType.NS,
 *         ZoneId = example.ZoneId,
 *         Records = new[]
 *         {
 *             example.NameServers.Apply(nameServers => nameServers[0]),
 *             example.NameServers.Apply(nameServers => nameServers[1]),
 *             example.NameServers.Apply(nameServers => nameServers[2]),
 *             example.NameServers.Apply(nameServers => nameServers[3]),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := route53.NewZone(ctx, "example", &route53.ZoneArgs{
 * 			Name: pulumi.String("test.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewRecord(ctx, "example", &route53.RecordArgs{
 * 			AllowOverwrite: pulumi.Bool(true),
 * 			Name:           pulumi.String("test.example.com"),
 * 			Ttl:            pulumi.Int(172800),
 * 			Type:           pulumi.String(route53.RecordTypeNS),
 * 			ZoneId:         example.ZoneId,
 * 			Records: pulumi.StringArray{
 * 				example.NameServers.ApplyT(func(nameServers []string) (string, error) {
 * 					return nameServers[0], nil
 * 				}).(pulumi.StringOutput),
 * 				example.NameServers.ApplyT(func(nameServers []string) (string, error) {
 * 					return nameServers[1], nil
 * 				}).(pulumi.StringOutput),
 * 				example.NameServers.ApplyT(func(nameServers []string) (string, error) {
 * 					return nameServers[2], nil
 * 				}).(pulumi.StringOutput),
 * 				example.NameServers.ApplyT(func(nameServers []string) (string, error) {
 * 					return nameServers[3], nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Zone("example", ZoneArgs.builder()
 *             .name("test.example.com")
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .allowOverwrite(true)
 *             .name("test.example.com")
 *             .ttl(172800)
 *             .type("NS")
 *             .zoneId(example.zoneId())
 *             .records(
 *                 example.nameServers().applyValue(nameServers -> nameServers[0]),
 *                 example.nameServers().applyValue(nameServers -> nameServers[1]),
 *                 example.nameServers().applyValue(nameServers -> nameServers[2]),
 *                 example.nameServers().applyValue(nameServers -> nameServers[3]))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:Zone
 *     properties:
 *       name: test.example.com
 *   exampleRecord:
 *     type: aws:route53:Record
 *     name: example
 *     properties:
 *       allowOverwrite: true
 *       name: test.example.com
 *       ttl: 172800
 *       type: NS
 *       zoneId: ${example.zoneId}
 *       records:
 *         - ${example.nameServers[0]}
 *         - ${example.nameServers[1]}
 *         - ${example.nameServers[2]}
 *         - ${example.nameServers[3]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * If the record also contains a set identifier, append it:
 * If the record name is the empty string, it can be omitted:
 * __Using `pulumi import` to import__ Route53 Records using the ID of the record, record name, record type, and set identifier. For example:
 * Using the ID of the record, which is the zone identifier, record name, and record type, separated by underscores (`_`):
 * ```sh
 * $ pulumi import aws:route53/record:Record myrecord Z4KAPRWWNC7JR_dev.example.com_NS
 * ```
 * If the record also contains a set identifier, append it:
 * ```sh
 * $ pulumi import aws:route53/record:Record myrecord Z4KAPRWWNC7JR_dev.example.com_NS_dev
 * ```
 */
public class Record internal constructor(
    override val javaResource: com.pulumi.aws.route53.Record,
) : KotlinCustomResource(javaResource, RecordMapper) {
    /**
     * An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    public val aliases: Output<List<RecordAlias>>?
        get() = javaResource.aliases().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> recordAliasToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
     * Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
     */
    public val allowOverwrite: Output<Boolean>
        get() = javaResource.allowOverwrite().applyValue({ args0 -> args0 })

    /**
     * A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
     */
    public val cidrRoutingPolicy: Output<RecordCidrRoutingPolicy>?
        get() = javaResource.cidrRoutingPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> recordCidrRoutingPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    public val failoverRoutingPolicies: Output<List<RecordFailoverRoutingPolicy>>?
        get() = javaResource.failoverRoutingPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        recordFailoverRoutingPolicyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * [FQDN](https://en.wikipedia.org/wiki/Fully_qualified_domain_name) built using the zone domain and `name`.
     */
    public val fqdn: Output<String>
        get() = javaResource.fqdn().applyValue({ args0 -> args0 })

    /**
     * A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    public val geolocationRoutingPolicies: Output<List<RecordGeolocationRoutingPolicy>>?
        get() = javaResource.geolocationRoutingPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        recordGeolocationRoutingPolicyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A block indicating a routing policy based on the geoproximity of the requestor. Conflicts with any other routing policy. Documented below.
     */
    public val geoproximityRoutingPolicy: Output<RecordGeoproximityRoutingPolicy>?
        get() = javaResource.geoproximityRoutingPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> recordGeoproximityRoutingPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The health check the record should be associated with.
     */
    public val healthCheckId: Output<String>?
        get() = javaResource.healthCheckId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    public val latencyRoutingPolicies: Output<List<RecordLatencyRoutingPolicy>>?
        get() = javaResource.latencyRoutingPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        recordLatencyRoutingPolicyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
     */
    public val multivalueAnswerRoutingPolicy: Output<Boolean>?
        get() = javaResource.multivalueAnswerRoutingPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the record.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
     */
    public val records: Output<List<String>>?
        get() = javaResource.records().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`,`geoproximity_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
     */
    public val setIdentifier: Output<String>?
        get() = javaResource.setIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The TTL of the record.
     */
    public val ttl: Output<Int>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    public val weightedRoutingPolicies: Output<List<RecordWeightedRoutingPolicy>>?
        get() = javaResource.weightedRoutingPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        recordWeightedRoutingPolicyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The ID of the hosted zone to contain this record.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object RecordMapper : ResourceMapper<Record> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.Record::class == javaResource::class

    override fun map(javaResource: Resource): Record = Record(
        javaResource as
            com.pulumi.aws.route53.Record,
    )
}

/**
 * @see [Record].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Record].
 */
public suspend fun record(name: String, block: suspend RecordResourceBuilder.() -> Unit): Record {
    val builder = RecordResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Record].
 * @param name The _unique_ name of the resulting resource.
 */
public fun record(name: String): Record {
    val builder = RecordResourceBuilder()
    builder.name(name)
    return builder.build()
}
