@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.RecordArgs.builder
import com.pulumi.aws.route53.kotlin.enums.RecordType
import com.pulumi.aws.route53.kotlin.inputs.RecordAliasArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordAliasArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordCidrRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordCidrRoutingPolicyArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordFailoverRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordFailoverRoutingPolicyArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordGeolocationRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordGeolocationRoutingPolicyArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordGeoproximityRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordGeoproximityRoutingPolicyArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordLatencyRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordLatencyRoutingPolicyArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordWeightedRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordWeightedRoutingPolicyArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Route53 record resource.
 * ## Example Usage
 * ### Simple routing policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const www = new aws.route53.Record("www", {
 *     zoneId: primary.zoneId,
 *     name: "www.example.com",
 *     type: aws.route53.RecordType.A,
 *     ttl: 300,
 *     records: [lb&#46;publicIp],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * www = aws.route53.Record("www",
 *     zone_id=primary["zoneId"],
 *     name="www.example.com",
 *     type=aws.route53.RecordType.A,
 *     ttl=300,
 *     records=[lb["publicIp"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var www = new Aws.Route53.Record("www", new()
 *     {
 *         ZoneId = primary.ZoneId,
 *         Name = "www.example.com",
 *         Type = Aws.Route53.RecordType.A,
 *         Ttl = 300,
 *         Records = new[]
 *         {
 *             lb.PublicIp,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewRecord(ctx, "www", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(primary.ZoneId),
 * 			Name:   pulumi.String("www.example.com"),
 * 			Type:   pulumi.String(route53.RecordTypeA),
 * 			Ttl:    pulumi.Int(300),
 * 			Records: pulumi.StringArray{
 * 				lb.PublicIp,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var www = new Record("www", RecordArgs.builder()
 *             .zoneId(primary.zoneId())
 *             .name("www.example.com")
 *             .type("A")
 *             .ttl(300)
 *             .records(lb.publicIp())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   www:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${primary.zoneId}
 *       name: www.example.com
 *       type: A
 *       ttl: 300
 *       records:
 *         - ${lb.publicIp}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Weighted routing policy
 * Other routing policies are configured similarly. See [Amazon Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html) for details.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const www_dev = new aws.route53.Record("www-dev", {
 *     zoneId: primary.zoneId,
 *     name: "www",
 *     type: aws.route53.RecordType.CNAME,
 *     ttl: 5,
 *     weightedRoutingPolicies: [{
 *         weight: 10,
 *     }],
 *     setIdentifier: "dev",
 *     records: ["dev&#46;example&#46;com"],
 * });
 * const www_live = new aws.route53.Record("www-live", {
 *     zoneId: primary.zoneId,
 *     name: "www",
 *     type: aws.route53.RecordType.CNAME,
 *     ttl: 5,
 *     weightedRoutingPolicies: [{
 *         weight: 90,
 *     }],
 *     setIdentifier: "live",
 *     records: ["live&#46;example&#46;com"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * www_dev = aws.route53.Record("www-dev",
 *     zone_id=primary["zoneId"],
 *     name="www",
 *     type=aws.route53.RecordType.CNAME,
 *     ttl=5,
 *     weighted_routing_policies=[{
 *         "weight": 10,
 *     }],
 *     set_identifier="dev",
 *     records=["dev&#46;example&#46;com"])
 * www_live = aws.route53.Record("www-live",
 *     zone_id=primary["zoneId"],
 *     name="www",
 *     type=aws.route53.RecordType.CNAME,
 *     ttl=5,
 *     weighted_routing_policies=[{
 *         "weight": 90,
 *     }],
 *     set_identifier="live",
 *     records=["live&#46;example&#46;com"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var www_dev = new Aws.Route53.Record("www-dev", new()
 *     {
 *         ZoneId = primary.ZoneId,
 *         Name = "www",
 *         Type = Aws.Route53.RecordType.CNAME,
 *         Ttl = 5,
 *         WeightedRoutingPolicies = new[]
 *         {
 *             new Aws.Route53.Inputs.RecordWeightedRoutingPolicyArgs
 *             {
 *                 Weight = 10,
 *             },
 *         },
 *         SetIdentifier = "dev",
 *         Records = new[]
 *         {
 *             "dev.example.com",
 *         },
 *     });
 *     var www_live = new Aws.Route53.Record("www-live", new()
 *     {
 *         ZoneId = primary.ZoneId,
 *         Name = "www",
 *         Type = Aws.Route53.RecordType.CNAME,
 *         Ttl = 5,
 *         WeightedRoutingPolicies = new[]
 *         {
 *             new Aws.Route53.Inputs.RecordWeightedRoutingPolicyArgs
 *             {
 *                 Weight = 90,
 *             },
 *         },
 *         SetIdentifier = "live",
 *         Records = new[]
 *         {
 *             "live.example.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewRecord(ctx, "www-dev", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(primary.ZoneId),
 * 			Name:   pulumi.String("www"),
 * 			Type:   pulumi.String(route53.RecordTypeCNAME),
 * 			Ttl:    pulumi.Int(5),
 * 			WeightedRoutingPolicies: route53.RecordWeightedRoutingPolicyArray{
 * 				&route53.RecordWeightedRoutingPolicyArgs{
 * 					Weight: pulumi.Int(10),
 * 				},
 * 			},
 * 			SetIdentifier: pulumi.String("dev"),
 * 			Records: pulumi.StringArray{
 * 				pulumi.String("dev.example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewRecord(ctx, "www-live", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(primary.ZoneId),
 * 			Name:   pulumi.String("www"),
 * 			Type:   pulumi.String(route53.RecordTypeCNAME),
 * 			Ttl:    pulumi.Int(5),
 * 			WeightedRoutingPolicies: route53.RecordWeightedRoutingPolicyArray{
 * 				&route53.RecordWeightedRoutingPolicyArgs{
 * 					Weight: pulumi.Int(90),
 * 				},
 * 			},
 * 			SetIdentifier: pulumi.String("live"),
 * 			Records: pulumi.StringArray{
 * 				pulumi.String("live.example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordWeightedRoutingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var www_dev = new Record("www-dev", RecordArgs.builder()
 *             .zoneId(primary.zoneId())
 *             .name("www")
 *             .type("CNAME")
 *             .ttl(5)
 *             .weightedRoutingPolicies(RecordWeightedRoutingPolicyArgs.builder()
 *                 .weight(10)
 *                 .build())
 *             .setIdentifier("dev")
 *             .records("dev.example.com")
 *             .build());
 *         var www_live = new Record("www-live", RecordArgs.builder()
 *             .zoneId(primary.zoneId())
 *             .name("www")
 *             .type("CNAME")
 *             .ttl(5)
 *             .weightedRoutingPolicies(RecordWeightedRoutingPolicyArgs.builder()
 *                 .weight(90)
 *                 .build())
 *             .setIdentifier("live")
 *             .records("live.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   www-dev:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${primary.zoneId}
 *       name: www
 *       type: CNAME
 *       ttl: 5
 *       weightedRoutingPolicies:
 *         - weight: 10
 *       setIdentifier: dev
 *       records:
 *         - dev.example.com
 *   www-live:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${primary.zoneId}
 *       name: www
 *       type: CNAME
 *       ttl: 5
 *       weightedRoutingPolicies:
 *         - weight: 90
 *       setIdentifier: live
 *       records:
 *         - live.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Geoproximity routing policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const www = new aws.route53.Record("www", {
 *     zoneId: primary.zoneId,
 *     name: "www.example.com",
 *     type: aws.route53.RecordType.CNAME,
 *     ttl: 300,
 *     geoproximityRoutingPolicy: {
 *         coordinates: [{
 *             latitude: "49.22",
 *             longitude: "-74.01",
 *         }],
 *     },
 *     setIdentifier: "dev",
 *     records: ["dev&#46;example&#46;com"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * www = aws.route53.Record("www",
 *     zone_id=primary["zoneId"],
 *     name="www.example.com",
 *     type=aws.route53.RecordType.CNAME,
 *     ttl=300,
 *     geoproximity_routing_policy={
 *         "coordinates": [{
 *             "latitude": "49.22",
 *             "longitude": "-74.01",
 *         }],
 *     },
 *     set_identifier="dev",
 *     records=["dev&#46;example&#46;com"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var www = new Aws.Route53.Record("www", new()
 *     {
 *         ZoneId = primary.ZoneId,
 *         Name = "www.example.com",
 *         Type = Aws.Route53.RecordType.CNAME,
 *         Ttl = 300,
 *         GeoproximityRoutingPolicy = new Aws.Route53.Inputs.RecordGeoproximityRoutingPolicyArgs
 *         {
 *             Coordinates = new[]
 *             {
 *                 new Aws.Route53.Inputs.RecordGeoproximityRoutingPolicyCoordinateArgs
 *                 {
 *                     Latitude = "49.22",
 *                     Longitude = "-74.01",
 *                 },
 *             },
 *         },
 *         SetIdentifier = "dev",
 *         Records = new[]
 *         {
 *             "dev.example.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewRecord(ctx, "www", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(primary.ZoneId),
 * 			Name:   pulumi.String("www.example.com"),
 * 			Type:   pulumi.String(route53.RecordTypeCNAME),
 * 			Ttl:    pulumi.Int(300),
 * 			GeoproximityRoutingPolicy: &route53.RecordGeoproximityRoutingPolicyArgs{
 * 				Coordinates: route53.RecordGeoproximityRoutingPolicyCoordinateArray{
 * 					&route53.RecordGeoproximityRoutingPolicyCoordinateArgs{
 * 						Latitude:  pulumi.String("49.22"),
 * 						Longitude: pulumi.String("-74.01"),
 * 					},
 * 				},
 * 			},
 * 			SetIdentifier: pulumi.String("dev"),
 * 			Records: pulumi.StringArray{
 * 				pulumi.String("dev.example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordGeoproximityRoutingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var www = new Record("www", RecordArgs.builder()
 *             .zoneId(primary.zoneId())
 *             .name("www.example.com")
 *             .type("CNAME")
 *             .ttl(300)
 *             .geoproximityRoutingPolicy(RecordGeoproximityRoutingPolicyArgs.builder()
 *                 .coordinates(RecordGeoproximityRoutingPolicyCoordinateArgs.builder()
 *                     .latitude("49.22")
 *                     .longitude("-74.01")
 *                     .build())
 *                 .build())
 *             .setIdentifier("dev")
 *             .records("dev.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   www:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${primary.zoneId}
 *       name: www.example.com
 *       type: CNAME
 *       ttl: 300
 *       geoproximityRoutingPolicy:
 *         coordinates:
 *           - latitude: '49.22'
 *             longitude: '-74.01'
 *       setIdentifier: dev
 *       records:
 *         - dev.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Alias record
 * See [related part of Amazon Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-choosing-alias-non-alias.html)
 * to understand differences between alias and non-alias records.
 * TTL for all alias records is [60 seconds](https://aws.amazon.com/route53/faqs/#dns_failover_do_i_need_to_adjust),
 * you cannot change this, therefore `ttl` has to be omitted in alias records.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.elb.LoadBalancer("main", {
 *     name: "foobar-elb",
 *     availabilityZones: ["us-east-1c"],
 *     listeners: [{
 *         instancePort: 80,
 *         instanceProtocol: "http",
 *         lbPort: 80,
 *         lbProtocol: "http",
 *     }],
 * });
 * const www = new aws.route53.Record("www", {
 *     zoneId: primary.zoneId,
 *     name: "example.com",
 *     type: aws.route53.RecordType.A,
 *     aliases: [{
 *         name: main.dnsName,
 *         zoneId: main.zoneId,
 *         evaluateTargetHealth: true,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.elb.LoadBalancer("main",
 *     name="foobar-elb",
 *     availability_zones=["us-east-1c"],
 *     listeners=[{
 *         "instance_port": 80,
 *         "instance_protocol": "http",
 *         "lb_port": 80,
 *         "lb_protocol": "http",
 *     }])
 * www = aws.route53.Record("www",
 *     zone_id=primary["zoneId"],
 *     name="example.com",
 *     type=aws.route53.RecordType.A,
 *     aliases=[{
 *         "name": main.dns_name,
 *         "zone_id": main.zone_id,
 *         "evaluate_target_health": True,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Elb.LoadBalancer("main", new()
 *     {
 *         Name = "foobar-elb",
 *         AvailabilityZones = new[]
 *         {
 *             "us-east-1c",
 *         },
 *         Listeners = new[]
 *         {
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 80,
 *                 InstanceProtocol = "http",
 *                 LbPort = 80,
 *                 LbProtocol = "http",
 *             },
 *         },
 *     });
 *     var www = new Aws.Route53.Record("www", new()
 *     {
 *         ZoneId = primary.ZoneId,
 *         Name = "example.com",
 *         Type = Aws.Route53.RecordType.A,
 *         Aliases = new[]
 *         {
 *             new Aws.Route53.Inputs.RecordAliasArgs
 *             {
 *                 Name = main.DnsName,
 *                 ZoneId = main.ZoneId,
 *                 EvaluateTargetHealth = true,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elb"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := elb.NewLoadBalancer(ctx, "main", &elb.LoadBalancerArgs{
 * 			Name: pulumi.String("foobar-elb"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-east-1c"),
 * 			},
 * 			Listeners: elb.LoadBalancerListenerArray{
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(80),
 * 					InstanceProtocol: pulumi.String("http"),
 * 					LbPort:           pulumi.Int(80),
 * 					LbProtocol:       pulumi.String("http"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewRecord(ctx, "www", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(primary.ZoneId),
 * 			Name:   pulumi.String("example.com"),
 * 			Type:   pulumi.String(route53.RecordTypeA),
 * 			Aliases: route53.RecordAliasArray{
 * 				&route53.RecordAliasArgs{
 * 					Name:                 main.DnsName,
 * 					ZoneId:               main.ZoneId,
 * 					EvaluateTargetHealth: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new LoadBalancer("main", LoadBalancerArgs.builder()
 *             .name("foobar-elb")
 *             .availabilityZones("us-east-1c")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(80)
 *                 .instanceProtocol("http")
 *                 .lbPort(80)
 *                 .lbProtocol("http")
 *                 .build())
 *             .build());
 *         var www = new Record("www", RecordArgs.builder()
 *             .zoneId(primary.zoneId())
 *             .name("example.com")
 *             .type("A")
 *             .aliases(RecordAliasArgs.builder()
 *                 .name(main.dnsName())
 *                 .zoneId(main.zoneId())
 *                 .evaluateTargetHealth(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:elb:LoadBalancer
 *     properties:
 *       name: foobar-elb
 *       availabilityZones:
 *         - us-east-1c
 *       listeners:
 *         - instancePort: 80
 *           instanceProtocol: http
 *           lbPort: 80
 *           lbProtocol: http
 *   www:
 *     type: aws:route53:Record
 *     properties:
 *       zoneId: ${primary.zoneId}
 *       name: example.com
 *       type: A
 *       aliases:
 *         - name: ${main.dnsName}
 *           zoneId: ${main.zoneId}
 *           evaluateTargetHealth: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### NS and SOA Record Management
 * When creating Route 53 zones, the `NS` and `SOA` records for the zone are automatically created. Enabling the `allow_overwrite` argument will allow managing these records in a single deployment without the requirement for `import`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.Zone("example", {name: "test.example.com"});
 * const exampleRecord = new aws.route53.Record("example", {
 *     allowOverwrite: true,
 *     name: "test.example.com",
 *     ttl: 172800,
 *     type: aws.route53.RecordType.NS,
 *     zoneId: example.zoneId,
 *     records: [
 *         example.nameServers[0],
 *         example.nameServers[1],
 *         example.nameServers[2],
 *         example.nameServers[3],
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.Zone("example", name="test.example.com")
 * example_record = aws.route53.Record("example",
 *     allow_overwrite=True,
 *     name="test.example.com",
 *     ttl=172800,
 *     type=aws.route53.RecordType.NS,
 *     zone_id=example.zone_id,
 *     records=[
 *         example.name_servers[0],
 *         example.name_servers[1],
 *         example.name_servers[2],
 *         example.name_servers[3],
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.Zone("example", new()
 *     {
 *         Name = "test.example.com",
 *     });
 *     var exampleRecord = new Aws.Route53.Record("example", new()
 *     {
 *         AllowOverwrite = true,
 *         Name = "test.example.com",
 *         Ttl = 172800,
 *         Type = Aws.Route53.RecordType.NS,
 *         ZoneId = example.ZoneId,
 *         Records = new[]
 *         {
 *             example.NameServers.Apply(nameServers => nameServers[0]),
 *             example.NameServers.Apply(nameServers => nameServers[1]),
 *             example.NameServers.Apply(nameServers => nameServers[2]),
 *             example.NameServers.Apply(nameServers => nameServers[3]),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := route53.NewZone(ctx, "example", &route53.ZoneArgs{
 * 			Name: pulumi.String("test.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewRecord(ctx, "example", &route53.RecordArgs{
 * 			AllowOverwrite: pulumi.Bool(true),
 * 			Name:           pulumi.String("test.example.com"),
 * 			Ttl:            pulumi.Int(172800),
 * 			Type:           pulumi.String(route53.RecordTypeNS),
 * 			ZoneId:         example.ZoneId,
 * 			Records: pulumi.StringArray{
 * 				example.NameServers.ApplyT(func(nameServers []string) (string, error) {
 * 					return nameServers[0], nil
 * 				}).(pulumi.StringOutput),
 * 				example.NameServers.ApplyT(func(nameServers []string) (string, error) {
 * 					return nameServers[1], nil
 * 				}).(pulumi.StringOutput),
 * 				example.NameServers.ApplyT(func(nameServers []string) (string, error) {
 * 					return nameServers[2], nil
 * 				}).(pulumi.StringOutput),
 * 				example.NameServers.ApplyT(func(nameServers []string) (string, error) {
 * 					return nameServers[3], nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Zone("example", ZoneArgs.builder()
 *             .name("test.example.com")
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .allowOverwrite(true)
 *             .name("test.example.com")
 *             .ttl(172800)
 *             .type("NS")
 *             .zoneId(example.zoneId())
 *             .records(
 *                 example.nameServers().applyValue(nameServers -> nameServers[0]),
 *                 example.nameServers().applyValue(nameServers -> nameServers[1]),
 *                 example.nameServers().applyValue(nameServers -> nameServers[2]),
 *                 example.nameServers().applyValue(nameServers -> nameServers[3]))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:Zone
 *     properties:
 *       name: test.example.com
 *   exampleRecord:
 *     type: aws:route53:Record
 *     name: example
 *     properties:
 *       allowOverwrite: true
 *       name: test.example.com
 *       ttl: 172800
 *       type: NS
 *       zoneId: ${example.zoneId}
 *       records:
 *         - ${example.nameServers[0]}
 *         - ${example.nameServers[1]}
 *         - ${example.nameServers[2]}
 *         - ${example.nameServers[3]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * If the record also contains a set identifier, append it:
 * If the record name is the empty string, it can be omitted:
 * __Using `pulumi import` to import__ Route53 Records using the ID of the record, record name, record type, and set identifier. For example:
 * Using the ID of the record, which is the zone identifier, record name, and record type, separated by underscores (`_`):
 * ```sh
 * $ pulumi import aws:route53/record:Record myrecord Z4KAPRWWNC7JR_dev.example.com_NS
 * ```
 * If the record also contains a set identifier, append it:
 * ```sh
 * $ pulumi import aws:route53/record:Record myrecord Z4KAPRWWNC7JR_dev.example.com_NS_dev
 * ```
 * @property aliases An alias block. Conflicts with `ttl` & `records`.
 * Documented below.
 * @property allowOverwrite Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
 * Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
 * @property cidrRoutingPolicy A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
 * @property failoverRoutingPolicies A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
 * @property geolocationRoutingPolicies A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
 * @property geoproximityRoutingPolicy A block indicating a routing policy based on the geoproximity of the requestor. Conflicts with any other routing policy. Documented below.
 * @property healthCheckId The health check the record should be associated with.
 * @property latencyRoutingPolicies A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
 * @property multivalueAnswerRoutingPolicy Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
 * @property name The name of the record.
 * @property records A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
 * @property setIdentifier Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`,`geoproximity_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
 * @property ttl The TTL of the record.
 * @property type The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
 * @property weightedRoutingPolicies A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
 * @property zoneId The ID of the hosted zone to contain this record.
 */
public data class RecordArgs(
    public val aliases: Output<List<RecordAliasArgs>>? = null,
    public val allowOverwrite: Output<Boolean>? = null,
    public val cidrRoutingPolicy: Output<RecordCidrRoutingPolicyArgs>? = null,
    public val failoverRoutingPolicies: Output<List<RecordFailoverRoutingPolicyArgs>>? = null,
    public val geolocationRoutingPolicies: Output<List<RecordGeolocationRoutingPolicyArgs>>? = null,
    public val geoproximityRoutingPolicy: Output<RecordGeoproximityRoutingPolicyArgs>? = null,
    public val healthCheckId: Output<String>? = null,
    public val latencyRoutingPolicies: Output<List<RecordLatencyRoutingPolicyArgs>>? = null,
    public val multivalueAnswerRoutingPolicy: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val records: Output<List<String>>? = null,
    public val setIdentifier: Output<String>? = null,
    public val ttl: Output<Int>? = null,
    public val type: Output<Either<String, RecordType>>? = null,
    public val weightedRoutingPolicies: Output<List<RecordWeightedRoutingPolicyArgs>>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.RecordArgs> {
    override fun toJava(): com.pulumi.aws.route53.RecordArgs =
        com.pulumi.aws.route53.RecordArgs.builder()
            .aliases(
                aliases?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .allowOverwrite(allowOverwrite?.applyValue({ args0 -> args0 }))
            .cidrRoutingPolicy(cidrRoutingPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .failoverRoutingPolicies(
                failoverRoutingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .geolocationRoutingPolicies(
                geolocationRoutingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .geoproximityRoutingPolicy(
                geoproximityRoutingPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .healthCheckId(healthCheckId?.applyValue({ args0 -> args0 }))
            .latencyRoutingPolicies(
                latencyRoutingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .multivalueAnswerRoutingPolicy(multivalueAnswerRoutingPolicy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .records(records?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .setIdentifier(setIdentifier?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .weightedRoutingPolicies(
                weightedRoutingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordArgs].
 */
@PulumiTagMarker
public class RecordArgsBuilder internal constructor() {
    private var aliases: Output<List<RecordAliasArgs>>? = null

    private var allowOverwrite: Output<Boolean>? = null

    private var cidrRoutingPolicy: Output<RecordCidrRoutingPolicyArgs>? = null

    private var failoverRoutingPolicies: Output<List<RecordFailoverRoutingPolicyArgs>>? = null

    private var geolocationRoutingPolicies: Output<List<RecordGeolocationRoutingPolicyArgs>>? = null

    private var geoproximityRoutingPolicy: Output<RecordGeoproximityRoutingPolicyArgs>? = null

    private var healthCheckId: Output<String>? = null

    private var latencyRoutingPolicies: Output<List<RecordLatencyRoutingPolicyArgs>>? = null

    private var multivalueAnswerRoutingPolicy: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var records: Output<List<String>>? = null

    private var setIdentifier: Output<String>? = null

    private var ttl: Output<Int>? = null

    private var type: Output<Either<String, RecordType>>? = null

    private var weightedRoutingPolicies: Output<List<RecordWeightedRoutingPolicyArgs>>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("qlrpnowrtkcbrpot")
    public suspend fun aliases(`value`: Output<List<RecordAliasArgs>>) {
        this.aliases = value
    }

    @JvmName("rqpwlucuunuewhpw")
    public suspend fun aliases(vararg values: Output<RecordAliasArgs>) {
        this.aliases = Output.all(values.asList())
    }

    /**
     * @param values An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("hvcwoqulwwgqjgwy")
    public suspend fun aliases(values: List<Output<RecordAliasArgs>>) {
        this.aliases = Output.all(values)
    }

    /**
     * @param value Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
     * Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
     */
    @JvmName("xygywaljtwkwkvfs")
    public suspend fun allowOverwrite(`value`: Output<Boolean>) {
        this.allowOverwrite = value
    }

    /**
     * @param value A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("nwwrggfnjsxwuxms")
    public suspend fun cidrRoutingPolicy(`value`: Output<RecordCidrRoutingPolicyArgs>) {
        this.cidrRoutingPolicy = value
    }

    /**
     * @param value A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("xmywejyifnknokto")
    public suspend fun failoverRoutingPolicies(`value`: Output<List<RecordFailoverRoutingPolicyArgs>>) {
        this.failoverRoutingPolicies = value
    }

    @JvmName("nvkdhriugufvbrnn")
    public suspend fun failoverRoutingPolicies(vararg values: Output<RecordFailoverRoutingPolicyArgs>) {
        this.failoverRoutingPolicies = Output.all(values.asList())
    }

    /**
     * @param values A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("htmtmlffcyucjlpg")
    public suspend fun failoverRoutingPolicies(values: List<Output<RecordFailoverRoutingPolicyArgs>>) {
        this.failoverRoutingPolicies = Output.all(values)
    }

    /**
     * @param value A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("gkqnpwekdsnfeekc")
    public suspend fun geolocationRoutingPolicies(`value`: Output<List<RecordGeolocationRoutingPolicyArgs>>) {
        this.geolocationRoutingPolicies = value
    }

    @JvmName("xmebxxnqovqdtuge")
    public suspend fun geolocationRoutingPolicies(vararg values: Output<RecordGeolocationRoutingPolicyArgs>) {
        this.geolocationRoutingPolicies = Output.all(values.asList())
    }

    /**
     * @param values A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("mivnbddjcxyhbosf")
    public suspend fun geolocationRoutingPolicies(values: List<Output<RecordGeolocationRoutingPolicyArgs>>) {
        this.geolocationRoutingPolicies = Output.all(values)
    }

    /**
     * @param value A block indicating a routing policy based on the geoproximity of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("yiigbgphwyylqsie")
    public suspend fun geoproximityRoutingPolicy(`value`: Output<RecordGeoproximityRoutingPolicyArgs>) {
        this.geoproximityRoutingPolicy = value
    }

    /**
     * @param value The health check the record should be associated with.
     */
    @JvmName("kgjelptjisoysywf")
    public suspend fun healthCheckId(`value`: Output<String>) {
        this.healthCheckId = value
    }

    /**
     * @param value A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("jyfxceppvnrsgdke")
    public suspend fun latencyRoutingPolicies(`value`: Output<List<RecordLatencyRoutingPolicyArgs>>) {
        this.latencyRoutingPolicies = value
    }

    @JvmName("axitgaulvifolfdi")
    public suspend fun latencyRoutingPolicies(vararg values: Output<RecordLatencyRoutingPolicyArgs>) {
        this.latencyRoutingPolicies = Output.all(values.asList())
    }

    /**
     * @param values A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("jkedbxklchxfcjag")
    public suspend fun latencyRoutingPolicies(values: List<Output<RecordLatencyRoutingPolicyArgs>>) {
        this.latencyRoutingPolicies = Output.all(values)
    }

    /**
     * @param value Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
     */
    @JvmName("djcpfslifyppswec")
    public suspend fun multivalueAnswerRoutingPolicy(`value`: Output<Boolean>) {
        this.multivalueAnswerRoutingPolicy = value
    }

    /**
     * @param value The name of the record.
     */
    @JvmName("oititmgjkxkvpkos")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
     */
    @JvmName("oppoquyxmilyqahv")
    public suspend fun records(`value`: Output<List<String>>) {
        this.records = value
    }

    @JvmName("hiqfwetycstmntmi")
    public suspend fun records(vararg values: Output<String>) {
        this.records = Output.all(values.asList())
    }

    /**
     * @param values A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
     */
    @JvmName("ccpiqboanvqkgnrd")
    public suspend fun records(values: List<Output<String>>) {
        this.records = Output.all(values)
    }

    /**
     * @param value Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`,`geoproximity_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
     */
    @JvmName("fruksmnbrbltbtjk")
    public suspend fun setIdentifier(`value`: Output<String>) {
        this.setIdentifier = value
    }

    /**
     * @param value The TTL of the record.
     */
    @JvmName("pbufyccqrgjbjcdy")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     */
    @JvmName("jlhaanjwbtypyhhi")
    public suspend fun type(`value`: Output<Either<String, RecordType>>) {
        this.type = value
    }

    /**
     * @param value A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("kdjinscxyebeaerf")
    public suspend fun weightedRoutingPolicies(`value`: Output<List<RecordWeightedRoutingPolicyArgs>>) {
        this.weightedRoutingPolicies = value
    }

    @JvmName("nehpkxxhdtboqnad")
    public suspend fun weightedRoutingPolicies(vararg values: Output<RecordWeightedRoutingPolicyArgs>) {
        this.weightedRoutingPolicies = Output.all(values.asList())
    }

    /**
     * @param values A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("cblvwqjtrfoleivv")
    public suspend fun weightedRoutingPolicies(values: List<Output<RecordWeightedRoutingPolicyArgs>>) {
        this.weightedRoutingPolicies = Output.all(values)
    }

    /**
     * @param value The ID of the hosted zone to contain this record.
     */
    @JvmName("dojixiycvagrrfmx")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("hgxpljtrrhdcrtby")
    public suspend fun aliases(`value`: List<RecordAliasArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param argument An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("ofpmvrcvoncmpyan")
    public suspend fun aliases(argument: List<suspend RecordAliasArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RecordAliasArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aliases = mapped
    }

    /**
     * @param argument An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("mfjrhhqyvfiofuhh")
    public suspend fun aliases(vararg argument: suspend RecordAliasArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RecordAliasArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aliases = mapped
    }

    /**
     * @param argument An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("ucvfyaptjuhhpttq")
    public suspend fun aliases(argument: suspend RecordAliasArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RecordAliasArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.aliases = mapped
    }

    /**
     * @param values An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("tdstctdhvlpevkyy")
    public suspend fun aliases(vararg values: RecordAliasArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param value Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
     * Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
     */
    @JvmName("uwdlvckcmpwseaec")
    public suspend fun allowOverwrite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowOverwrite = mapped
    }

    /**
     * @param value A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("awdblqecfvbyksiw")
    public suspend fun cidrRoutingPolicy(`value`: RecordCidrRoutingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrRoutingPolicy = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("owctltvefgairofy")
    public suspend fun cidrRoutingPolicy(argument: suspend RecordCidrRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RecordCidrRoutingPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cidrRoutingPolicy = mapped
    }

    /**
     * @param value A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("exkmwrqwtmnpibkf")
    public suspend fun failoverRoutingPolicies(`value`: List<RecordFailoverRoutingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("bfrxtkfomvbvccgs")
    public suspend fun failoverRoutingPolicies(argument: List<suspend RecordFailoverRoutingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecordFailoverRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.failoverRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("eesedtgklaicwgre")
    public suspend fun failoverRoutingPolicies(vararg argument: suspend RecordFailoverRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RecordFailoverRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.failoverRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("tttkvffbmjawxwsm")
    public suspend fun failoverRoutingPolicies(argument: suspend RecordFailoverRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecordFailoverRoutingPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.failoverRoutingPolicies = mapped
    }

    /**
     * @param values A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("dtlxkuppcjdbphoa")
    public suspend fun failoverRoutingPolicies(vararg values: RecordFailoverRoutingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverRoutingPolicies = mapped
    }

    /**
     * @param value A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("hgbhcgurlwyqvxjs")
    public suspend fun geolocationRoutingPolicies(`value`: List<RecordGeolocationRoutingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geolocationRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("suevbxyjerokkwva")
    public suspend fun geolocationRoutingPolicies(argument: List<suspend RecordGeolocationRoutingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecordGeolocationRoutingPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.geolocationRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("eauwbwagikxalhqg")
    public suspend fun geolocationRoutingPolicies(vararg argument: suspend RecordGeolocationRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RecordGeolocationRoutingPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.geolocationRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("qherrstslymxtsaq")
    public suspend fun geolocationRoutingPolicies(argument: suspend RecordGeolocationRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecordGeolocationRoutingPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.geolocationRoutingPolicies = mapped
    }

    /**
     * @param values A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("sfiafwsauxttygyn")
    public suspend fun geolocationRoutingPolicies(vararg values: RecordGeolocationRoutingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geolocationRoutingPolicies = mapped
    }

    /**
     * @param value A block indicating a routing policy based on the geoproximity of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("phwrbkltxdkntlxj")
    public suspend fun geoproximityRoutingPolicy(`value`: RecordGeoproximityRoutingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoproximityRoutingPolicy = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the geoproximity of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("vktrdxkxjkicaokq")
    public suspend fun geoproximityRoutingPolicy(argument: suspend RecordGeoproximityRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RecordGeoproximityRoutingPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.geoproximityRoutingPolicy = mapped
    }

    /**
     * @param value The health check the record should be associated with.
     */
    @JvmName("fauxigwehrqqoxqf")
    public suspend fun healthCheckId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckId = mapped
    }

    /**
     * @param value A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("idhsklkexuowdpju")
    public suspend fun latencyRoutingPolicies(`value`: List<RecordLatencyRoutingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latencyRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("skfhxfpxmwqkbutu")
    public suspend fun latencyRoutingPolicies(argument: List<suspend RecordLatencyRoutingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecordLatencyRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.latencyRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("cxlvydprsvhlujim")
    public suspend fun latencyRoutingPolicies(vararg argument: suspend RecordLatencyRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RecordLatencyRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.latencyRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("jxacptcqiekpgbnq")
    public suspend fun latencyRoutingPolicies(argument: suspend RecordLatencyRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecordLatencyRoutingPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.latencyRoutingPolicies = mapped
    }

    /**
     * @param values A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("pwninwdffjmdkofu")
    public suspend fun latencyRoutingPolicies(vararg values: RecordLatencyRoutingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.latencyRoutingPolicies = mapped
    }

    /**
     * @param value Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
     */
    @JvmName("ilmvyeekjfmgwfxm")
    public suspend fun multivalueAnswerRoutingPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multivalueAnswerRoutingPolicy = mapped
    }

    /**
     * @param value The name of the record.
     */
    @JvmName("kqikuwbdrrhfjslc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
     */
    @JvmName("csvnsyltliusbovf")
    public suspend fun records(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.records = mapped
    }

    /**
     * @param values A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
     */
    @JvmName("epxvyqymtenxwjqs")
    public suspend fun records(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.records = mapped
    }

    /**
     * @param value Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`,`geoproximity_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
     */
    @JvmName("oauilvffdafmhwea")
    public suspend fun setIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.setIdentifier = mapped
    }

    /**
     * @param value The TTL of the record.
     */
    @JvmName("symislobsnrbkkid")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     */
    @JvmName("meljvagycxmqwqtv")
    public suspend fun type(`value`: Either<String, RecordType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     */
    @JvmName("oravovbajbixoluy")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecordType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     */
    @JvmName("ibsxfqjsohfavgrl")
    public fun type(`value`: RecordType) {
        val toBeMapped = Either.ofRight<String, RecordType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("nhprlnmtghvugpfy")
    public suspend fun weightedRoutingPolicies(`value`: List<RecordWeightedRoutingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("uextlirdebpvjvyv")
    public suspend fun weightedRoutingPolicies(argument: List<suspend RecordWeightedRoutingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecordWeightedRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("qdbmqgcindfdtbwf")
    public suspend fun weightedRoutingPolicies(vararg argument: suspend RecordWeightedRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RecordWeightedRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("dbjxpmfvjhgnwfjp")
    public suspend fun weightedRoutingPolicies(argument: suspend RecordWeightedRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecordWeightedRoutingPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.weightedRoutingPolicies = mapped
    }

    /**
     * @param values A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("reosckvoftwabget")
    public suspend fun weightedRoutingPolicies(vararg values: RecordWeightedRoutingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedRoutingPolicies = mapped
    }

    /**
     * @param value The ID of the hosted zone to contain this record.
     */
    @JvmName("hwwsqyrguteugfdx")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): RecordArgs = RecordArgs(
        aliases = aliases,
        allowOverwrite = allowOverwrite,
        cidrRoutingPolicy = cidrRoutingPolicy,
        failoverRoutingPolicies = failoverRoutingPolicies,
        geolocationRoutingPolicies = geolocationRoutingPolicies,
        geoproximityRoutingPolicy = geoproximityRoutingPolicy,
        healthCheckId = healthCheckId,
        latencyRoutingPolicies = latencyRoutingPolicies,
        multivalueAnswerRoutingPolicy = multivalueAnswerRoutingPolicy,
        name = name,
        records = records,
        setIdentifier = setIdentifier,
        ttl = ttl,
        type = type,
        weightedRoutingPolicies = weightedRoutingPolicies,
        zoneId = zoneId,
    )
}
