@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResolverFirewallConfig].
 */
@PulumiTagMarker
public class ResolverFirewallConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverFirewallConfigArgs = ResolverFirewallConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverFirewallConfigArgsBuilder.() -> Unit) {
        val builder = ResolverFirewallConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResolverFirewallConfig {
        val builtJavaResource = com.pulumi.aws.route53.ResolverFirewallConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResolverFirewallConfig(builtJavaResource)
    }
}

/**
 * Provides a Route 53 Resolver DNS Firewall config resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.Vpc("example", {
 *     cidrBlock: "10.0.0.0/16",
 *     enableDnsSupport: true,
 *     enableDnsHostnames: true,
 * });
 * const exampleResolverFirewallConfig = new aws.route53.ResolverFirewallConfig("example", {
 *     resourceId: example.id,
 *     firewallFailOpen: "ENABLED",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.Vpc("example",
 *     cidr_block="10.0.0.0/16",
 *     enable_dns_support=True,
 *     enable_dns_hostnames=True)
 * example_resolver_firewall_config = aws.route53.ResolverFirewallConfig("example",
 *     resource_id=example.id,
 *     firewall_fail_open="ENABLED")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *         EnableDnsSupport = true,
 *         EnableDnsHostnames = true,
 *     });
 *     var exampleResolverFirewallConfig = new Aws.Route53.ResolverFirewallConfig("example", new()
 *     {
 *         ResourceId = example.Id,
 *         FirewallFailOpen = "ENABLED",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock:          pulumi.String("10.0.0.0/16"),
 * 			EnableDnsSupport:   pulumi.Bool(true),
 * 			EnableDnsHostnames: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewResolverFirewallConfig(ctx, "example", &route53.ResolverFirewallConfigArgs{
 * 			ResourceId:       example.ID(),
 * 			FirewallFailOpen: pulumi.String("ENABLED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.route53.ResolverFirewallConfig;
 * import com.pulumi.aws.route53.ResolverFirewallConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Vpc("example", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build());
 *         var exampleResolverFirewallConfig = new ResolverFirewallConfig("exampleResolverFirewallConfig", ResolverFirewallConfigArgs.builder()
 *             .resourceId(example.id())
 *             .firewallFailOpen("ENABLED")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *       enableDnsSupport: true
 *       enableDnsHostnames: true
 *   exampleResolverFirewallConfig:
 *     type: aws:route53:ResolverFirewallConfig
 *     name: example
 *     properties:
 *       resourceId: ${example.id}
 *       firewallFailOpen: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route 53 Resolver DNS Firewall configs using the Route 53 Resolver DNS Firewall config ID. For example:
 * ```sh
 * $ pulumi import aws:route53/resolverFirewallConfig:ResolverFirewallConfig example rdsc-be1866ecc1683e95
 * ```
 */
public class ResolverFirewallConfig internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverFirewallConfig,
) : KotlinCustomResource(javaResource, ResolverFirewallConfigMapper) {
    /**
     * Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
     */
    public val firewallFailOpen: Output<String>
        get() = javaResource.firewallFailOpen().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID of the owner of the VPC that this firewall configuration applies to.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC that the configuration is for.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })
}

public object ResolverFirewallConfigMapper : ResourceMapper<ResolverFirewallConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverFirewallConfig::class == javaResource::class

    override fun map(javaResource: Resource): ResolverFirewallConfig =
        ResolverFirewallConfig(javaResource as com.pulumi.aws.route53.ResolverFirewallConfig)
}

/**
 * @see [ResolverFirewallConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverFirewallConfig].
 */
public suspend fun resolverFirewallConfig(
    name: String,
    block: suspend ResolverFirewallConfigResourceBuilder.() -> Unit,
): ResolverFirewallConfig {
    val builder = ResolverFirewallConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverFirewallConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverFirewallConfig(name: String): ResolverFirewallConfig {
    val builder = ResolverFirewallConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
