@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverFirewallConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route 53 Resolver DNS Firewall config resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.Vpc("example", {
 *     cidrBlock: "10.0.0.0/16",
 *     enableDnsSupport: true,
 *     enableDnsHostnames: true,
 * });
 * const exampleResolverFirewallConfig = new aws.route53.ResolverFirewallConfig("example", {
 *     resourceId: example.id,
 *     firewallFailOpen: "ENABLED",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.Vpc("example",
 *     cidr_block="10.0.0.0/16",
 *     enable_dns_support=True,
 *     enable_dns_hostnames=True)
 * example_resolver_firewall_config = aws.route53.ResolverFirewallConfig("example",
 *     resource_id=example.id,
 *     firewall_fail_open="ENABLED")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *         EnableDnsSupport = true,
 *         EnableDnsHostnames = true,
 *     });
 *     var exampleResolverFirewallConfig = new Aws.Route53.ResolverFirewallConfig("example", new()
 *     {
 *         ResourceId = example.Id,
 *         FirewallFailOpen = "ENABLED",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock:          pulumi.String("10.0.0.0/16"),
 * 			EnableDnsSupport:   pulumi.Bool(true),
 * 			EnableDnsHostnames: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewResolverFirewallConfig(ctx, "example", &route53.ResolverFirewallConfigArgs{
 * 			ResourceId:       example.ID(),
 * 			FirewallFailOpen: pulumi.String("ENABLED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.route53.ResolverFirewallConfig;
 * import com.pulumi.aws.route53.ResolverFirewallConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Vpc("example", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build());
 *         var exampleResolverFirewallConfig = new ResolverFirewallConfig("exampleResolverFirewallConfig", ResolverFirewallConfigArgs.builder()
 *             .resourceId(example.id())
 *             .firewallFailOpen("ENABLED")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *       enableDnsSupport: true
 *       enableDnsHostnames: true
 *   exampleResolverFirewallConfig:
 *     type: aws:route53:ResolverFirewallConfig
 *     name: example
 *     properties:
 *       resourceId: ${example.id}
 *       firewallFailOpen: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route 53 Resolver DNS Firewall configs using the Route 53 Resolver DNS Firewall config ID. For example:
 * ```sh
 * $ pulumi import aws:route53/resolverFirewallConfig:ResolverFirewallConfig example rdsc-be1866ecc1683e95
 * ```
 * @property firewallFailOpen Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
 * @property resourceId The ID of the VPC that the configuration is for.
 */
public data class ResolverFirewallConfigArgs(
    public val firewallFailOpen: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverFirewallConfigArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverFirewallConfigArgs =
        com.pulumi.aws.route53.ResolverFirewallConfigArgs.builder()
            .firewallFailOpen(firewallFailOpen?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverFirewallConfigArgs].
 */
@PulumiTagMarker
public class ResolverFirewallConfigArgsBuilder internal constructor() {
    private var firewallFailOpen: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("kswefwmwypjjjbkm")
    public suspend fun firewallFailOpen(`value`: Output<String>) {
        this.firewallFailOpen = value
    }

    /**
     * @param value The ID of the VPC that the configuration is for.
     */
    @JvmName("kncvarpnmethqlbq")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("ootcqhaofqntwikq")
    public suspend fun firewallFailOpen(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallFailOpen = mapped
    }

    /**
     * @param value The ID of the VPC that the configuration is for.
     */
    @JvmName("rcbsosmtxtlajubu")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ResolverFirewallConfigArgs = ResolverFirewallConfigArgs(
        firewallFailOpen = firewallFailOpen,
        resourceId = resourceId,
    )
}
