@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ResolverFirewallDomainList].
 */
@PulumiTagMarker
public class ResolverFirewallDomainListResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverFirewallDomainListArgs = ResolverFirewallDomainListArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverFirewallDomainListArgsBuilder.() -> Unit) {
        val builder = ResolverFirewallDomainListArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResolverFirewallDomainList {
        val builtJavaResource =
            com.pulumi.aws.route53.ResolverFirewallDomainList(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResolverFirewallDomainList(builtJavaResource)
    }
}

/**
 * Provides a Route 53 Resolver DNS Firewall domain list resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.ResolverFirewallDomainList("example", {name: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.ResolverFirewallDomainList("example", name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.ResolverFirewallDomainList("example", new()
 *     {
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewResolverFirewallDomainList(ctx, "example", &route53.ResolverFirewallDomainListArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverFirewallDomainList;
 * import com.pulumi.aws.route53.ResolverFirewallDomainListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResolverFirewallDomainList("example", ResolverFirewallDomainListArgs.builder()
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:ResolverFirewallDomainList
 *     properties:
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import  Route 53 Resolver DNS Firewall domain lists using the Route 53 Resolver DNS Firewall domain list ID. For example:
 * ```sh
 * $ pulumi import aws:route53/resolverFirewallDomainList:ResolverFirewallDomainList example rslvr-fdl-0123456789abcdef
 * ```
 */
public class ResolverFirewallDomainList internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverFirewallDomainList,
) : KotlinCustomResource(javaResource, ResolverFirewallDomainListMapper) {
    /**
     * The ARN (Amazon Resource Name) of the domain list.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A array of domains for the firewall domain list.
     */
    public val domains: Output<List<String>>?
        get() = javaResource.domains().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * A name that lets you identify the domain list, to manage and use it.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. f configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ResolverFirewallDomainListMapper : ResourceMapper<ResolverFirewallDomainList> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverFirewallDomainList::class == javaResource::class

    override fun map(javaResource: Resource): ResolverFirewallDomainList =
        ResolverFirewallDomainList(javaResource as com.pulumi.aws.route53.ResolverFirewallDomainList)
}

/**
 * @see [ResolverFirewallDomainList].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverFirewallDomainList].
 */
public suspend fun resolverFirewallDomainList(
    name: String,
    block: suspend ResolverFirewallDomainListResourceBuilder.() -> Unit,
): ResolverFirewallDomainList {
    val builder = ResolverFirewallDomainListResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverFirewallDomainList].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverFirewallDomainList(name: String): ResolverFirewallDomainList {
    val builder = ResolverFirewallDomainListResourceBuilder()
    builder.name(name)
    return builder.build()
}
