@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResolverFirewallRule].
 */
@PulumiTagMarker
public class ResolverFirewallRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverFirewallRuleArgs = ResolverFirewallRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverFirewallRuleArgsBuilder.() -> Unit) {
        val builder = ResolverFirewallRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResolverFirewallRule {
        val builtJavaResource = com.pulumi.aws.route53.ResolverFirewallRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResolverFirewallRule(builtJavaResource)
    }
}

/**
 * Provides a Route 53 Resolver DNS Firewall rule resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.ResolverFirewallDomainList("example", {
 *     name: "example",
 *     domains: ["example&#46;com"],
 *     tags: {},
 * });
 * const exampleResolverFirewallRuleGroup = new aws.route53.ResolverFirewallRuleGroup("example", {
 *     name: "example",
 *     tags: {},
 * });
 * const exampleResolverFirewallRule = new aws.route53.ResolverFirewallRule("example", {
 *     name: "example",
 *     action: "BLOCK",
 *     blockOverrideDnsType: "CNAME",
 *     blockOverrideDomain: "example.com",
 *     blockOverrideTtl: 1,
 *     blockResponse: "OVERRIDE",
 *     firewallDomainListId: example.id,
 *     firewallRuleGroupId: exampleResolverFirewallRuleGroup.id,
 *     priority: 100,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.ResolverFirewallDomainList("example",
 *     name="example",
 *     domains=["example&#46;com"],
 *     tags={})
 * example_resolver_firewall_rule_group = aws.route53.ResolverFirewallRuleGroup("example",
 *     name="example",
 *     tags={})
 * example_resolver_firewall_rule = aws.route53.ResolverFirewallRule("example",
 *     name="example",
 *     action="BLOCK",
 *     block_override_dns_type="CNAME",
 *     block_override_domain="example.com",
 *     block_override_ttl=1,
 *     block_response="OVERRIDE",
 *     firewall_domain_list_id=example.id,
 *     firewall_rule_group_id=example_resolver_firewall_rule_group.id,
 *     priority=100)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.ResolverFirewallDomainList("example", new()
 *     {
 *         Name = "example",
 *         Domains = new[]
 *         {
 *             "example.com",
 *         },
 *         Tags = null,
 *     });
 *     var exampleResolverFirewallRuleGroup = new Aws.Route53.ResolverFirewallRuleGroup("example", new()
 *     {
 *         Name = "example",
 *         Tags = null,
 *     });
 *     var exampleResolverFirewallRule = new Aws.Route53.ResolverFirewallRule("example", new()
 *     {
 *         Name = "example",
 *         Action = "BLOCK",
 *         BlockOverrideDnsType = "CNAME",
 *         BlockOverrideDomain = "example.com",
 *         BlockOverrideTtl = 1,
 *         BlockResponse = "OVERRIDE",
 *         FirewallDomainListId = example.Id,
 *         FirewallRuleGroupId = exampleResolverFirewallRuleGroup.Id,
 *         Priority = 100,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := route53.NewResolverFirewallDomainList(ctx, "example", &route53.ResolverFirewallDomainListArgs{
 * 			Name: pulumi.String("example"),
 * 			Domains: pulumi.StringArray{
 * 				pulumi.String("example.com"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleResolverFirewallRuleGroup, err := route53.NewResolverFirewallRuleGroup(ctx, "example", &route53.ResolverFirewallRuleGroupArgs{
 * 			Name: pulumi.String("example"),
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewResolverFirewallRule(ctx, "example", &route53.ResolverFirewallRuleArgs{
 * 			Name:                 pulumi.String("example"),
 * 			Action:               pulumi.String("BLOCK"),
 * 			BlockOverrideDnsType: pulumi.String("CNAME"),
 * 			BlockOverrideDomain:  pulumi.String("example.com"),
 * 			BlockOverrideTtl:     pulumi.Int(1),
 * 			BlockResponse:        pulumi.String("OVERRIDE"),
 * 			FirewallDomainListId: example.ID(),
 * 			FirewallRuleGroupId:  exampleResolverFirewallRuleGroup.ID(),
 * 			Priority:             pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverFirewallDomainList;
 * import com.pulumi.aws.route53.ResolverFirewallDomainListArgs;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroup;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroupArgs;
 * import com.pulumi.aws.route53.ResolverFirewallRule;
 * import com.pulumi.aws.route53.ResolverFirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResolverFirewallDomainList("example", ResolverFirewallDomainListArgs.builder()
 *             .name("example")
 *             .domains("example.com")
 *             .tags()
 *             .build());
 *         var exampleResolverFirewallRuleGroup = new ResolverFirewallRuleGroup("exampleResolverFirewallRuleGroup", ResolverFirewallRuleGroupArgs.builder()
 *             .name("example")
 *             .tags()
 *             .build());
 *         var exampleResolverFirewallRule = new ResolverFirewallRule("exampleResolverFirewallRule", ResolverFirewallRuleArgs.builder()
 *             .name("example")
 *             .action("BLOCK")
 *             .blockOverrideDnsType("CNAME")
 *             .blockOverrideDomain("example.com")
 *             .blockOverrideTtl(1)
 *             .blockResponse("OVERRIDE")
 *             .firewallDomainListId(example.id())
 *             .firewallRuleGroupId(exampleResolverFirewallRuleGroup.id())
 *             .priority(100)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:ResolverFirewallDomainList
 *     properties:
 *       name: example
 *       domains:
 *         - example.com
 *       tags: {}
 *   exampleResolverFirewallRuleGroup:
 *     type: aws:route53:ResolverFirewallRuleGroup
 *     name: example
 *     properties:
 *       name: example
 *       tags: {}
 *   exampleResolverFirewallRule:
 *     type: aws:route53:ResolverFirewallRule
 *     name: example
 *     properties:
 *       name: example
 *       action: BLOCK
 *       blockOverrideDnsType: CNAME
 *       blockOverrideDomain: example.com
 *       blockOverrideTtl: 1
 *       blockResponse: OVERRIDE
 *       firewallDomainListId: ${example.id}
 *       firewallRuleGroupId: ${exampleResolverFirewallRuleGroup.id}
 *       priority: 100
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import  Route 53 Resolver DNS Firewall rules using the Route 53 Resolver DNS Firewall rule group ID and domain list ID separated by ':'. For example:
 * ```sh
 * $ pulumi import aws:route53/resolverFirewallRule:ResolverFirewallRule example rslvr-frg-0123456789abcdef:rslvr-fdl-0123456789abcdef
 * ```
 */
public class ResolverFirewallRule internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverFirewallRule,
) : KotlinCustomResource(javaResource, ResolverFirewallRuleMapper) {
    /**
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
     */
    public val action: Output<String>
        get() = javaResource.action().applyValue({ args0 -> args0 })

    /**
     * The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
     */
    public val blockOverrideDnsType: Output<String>?
        get() = javaResource.blockOverrideDnsType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The custom DNS record to send back in response to the query.
     */
    public val blockOverrideDomain: Output<String>?
        get() = javaResource.blockOverrideDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
     */
    public val blockOverrideTtl: Output<Int>?
        get() = javaResource.blockOverrideTtl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
     */
    public val blockResponse: Output<String>?
        get() = javaResource.blockResponse().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the domain list that you want to use in the rule.
     */
    public val firewallDomainListId: Output<String>
        get() = javaResource.firewallDomainListId().applyValue({ args0 -> args0 })

    /**
     * Evaluate DNS redirection in the DNS redirection chain, such as CNAME, DNAME, ot ALIAS. Valid values are `INSPECT_REDIRECTION_DOMAIN` and `TRUST_REDIRECTION_DOMAIN`. Default value is `INSPECT_REDIRECTION_DOMAIN`.
     */
    public val firewallDomainRedirectionAction: Output<String>?
        get() = javaResource.firewallDomainRedirectionAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique identifier of the firewall rule group where you want to create the rule.
     */
    public val firewallRuleGroupId: Output<String>
        get() = javaResource.firewallRuleGroupId().applyValue({ args0 -> args0 })

    /**
     * A name that lets you identify the rule, to manage and use it.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * The query type you want the rule to evaluate. Additional details can be found [here](https://en.wikipedia.org/wiki/List_of_DNS_record_types)
     */
    public val qType: Output<String>?
        get() = javaResource.qType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ResolverFirewallRuleMapper : ResourceMapper<ResolverFirewallRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverFirewallRule::class == javaResource::class

    override fun map(javaResource: Resource): ResolverFirewallRule = ResolverFirewallRule(
        javaResource
            as com.pulumi.aws.route53.ResolverFirewallRule,
    )
}

/**
 * @see [ResolverFirewallRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverFirewallRule].
 */
public suspend fun resolverFirewallRule(
    name: String,
    block: suspend ResolverFirewallRuleResourceBuilder.() -> Unit,
): ResolverFirewallRule {
    val builder = ResolverFirewallRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverFirewallRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverFirewallRule(name: String): ResolverFirewallRule {
    val builder = ResolverFirewallRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
