@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverFirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route 53 Resolver DNS Firewall rule resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.ResolverFirewallDomainList("example", {
 *     name: "example",
 *     domains: ["example&#46;com"],
 *     tags: {},
 * });
 * const exampleResolverFirewallRuleGroup = new aws.route53.ResolverFirewallRuleGroup("example", {
 *     name: "example",
 *     tags: {},
 * });
 * const exampleResolverFirewallRule = new aws.route53.ResolverFirewallRule("example", {
 *     name: "example",
 *     action: "BLOCK",
 *     blockOverrideDnsType: "CNAME",
 *     blockOverrideDomain: "example.com",
 *     blockOverrideTtl: 1,
 *     blockResponse: "OVERRIDE",
 *     firewallDomainListId: example.id,
 *     firewallRuleGroupId: exampleResolverFirewallRuleGroup.id,
 *     priority: 100,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.ResolverFirewallDomainList("example",
 *     name="example",
 *     domains=["example&#46;com"],
 *     tags={})
 * example_resolver_firewall_rule_group = aws.route53.ResolverFirewallRuleGroup("example",
 *     name="example",
 *     tags={})
 * example_resolver_firewall_rule = aws.route53.ResolverFirewallRule("example",
 *     name="example",
 *     action="BLOCK",
 *     block_override_dns_type="CNAME",
 *     block_override_domain="example.com",
 *     block_override_ttl=1,
 *     block_response="OVERRIDE",
 *     firewall_domain_list_id=example.id,
 *     firewall_rule_group_id=example_resolver_firewall_rule_group.id,
 *     priority=100)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.ResolverFirewallDomainList("example", new()
 *     {
 *         Name = "example",
 *         Domains = new[]
 *         {
 *             "example.com",
 *         },
 *         Tags = null,
 *     });
 *     var exampleResolverFirewallRuleGroup = new Aws.Route53.ResolverFirewallRuleGroup("example", new()
 *     {
 *         Name = "example",
 *         Tags = null,
 *     });
 *     var exampleResolverFirewallRule = new Aws.Route53.ResolverFirewallRule("example", new()
 *     {
 *         Name = "example",
 *         Action = "BLOCK",
 *         BlockOverrideDnsType = "CNAME",
 *         BlockOverrideDomain = "example.com",
 *         BlockOverrideTtl = 1,
 *         BlockResponse = "OVERRIDE",
 *         FirewallDomainListId = example.Id,
 *         FirewallRuleGroupId = exampleResolverFirewallRuleGroup.Id,
 *         Priority = 100,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := route53.NewResolverFirewallDomainList(ctx, "example", &route53.ResolverFirewallDomainListArgs{
 * 			Name: pulumi.String("example"),
 * 			Domains: pulumi.StringArray{
 * 				pulumi.String("example.com"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleResolverFirewallRuleGroup, err := route53.NewResolverFirewallRuleGroup(ctx, "example", &route53.ResolverFirewallRuleGroupArgs{
 * 			Name: pulumi.String("example"),
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = route53.NewResolverFirewallRule(ctx, "example", &route53.ResolverFirewallRuleArgs{
 * 			Name:                 pulumi.String("example"),
 * 			Action:               pulumi.String("BLOCK"),
 * 			BlockOverrideDnsType: pulumi.String("CNAME"),
 * 			BlockOverrideDomain:  pulumi.String("example.com"),
 * 			BlockOverrideTtl:     pulumi.Int(1),
 * 			BlockResponse:        pulumi.String("OVERRIDE"),
 * 			FirewallDomainListId: example.ID(),
 * 			FirewallRuleGroupId:  exampleResolverFirewallRuleGroup.ID(),
 * 			Priority:             pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverFirewallDomainList;
 * import com.pulumi.aws.route53.ResolverFirewallDomainListArgs;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroup;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroupArgs;
 * import com.pulumi.aws.route53.ResolverFirewallRule;
 * import com.pulumi.aws.route53.ResolverFirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResolverFirewallDomainList("example", ResolverFirewallDomainListArgs.builder()
 *             .name("example")
 *             .domains("example.com")
 *             .tags()
 *             .build());
 *         var exampleResolverFirewallRuleGroup = new ResolverFirewallRuleGroup("exampleResolverFirewallRuleGroup", ResolverFirewallRuleGroupArgs.builder()
 *             .name("example")
 *             .tags()
 *             .build());
 *         var exampleResolverFirewallRule = new ResolverFirewallRule("exampleResolverFirewallRule", ResolverFirewallRuleArgs.builder()
 *             .name("example")
 *             .action("BLOCK")
 *             .blockOverrideDnsType("CNAME")
 *             .blockOverrideDomain("example.com")
 *             .blockOverrideTtl(1)
 *             .blockResponse("OVERRIDE")
 *             .firewallDomainListId(example.id())
 *             .firewallRuleGroupId(exampleResolverFirewallRuleGroup.id())
 *             .priority(100)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:ResolverFirewallDomainList
 *     properties:
 *       name: example
 *       domains:
 *         - example.com
 *       tags: {}
 *   exampleResolverFirewallRuleGroup:
 *     type: aws:route53:ResolverFirewallRuleGroup
 *     name: example
 *     properties:
 *       name: example
 *       tags: {}
 *   exampleResolverFirewallRule:
 *     type: aws:route53:ResolverFirewallRule
 *     name: example
 *     properties:
 *       name: example
 *       action: BLOCK
 *       blockOverrideDnsType: CNAME
 *       blockOverrideDomain: example.com
 *       blockOverrideTtl: 1
 *       blockResponse: OVERRIDE
 *       firewallDomainListId: ${example.id}
 *       firewallRuleGroupId: ${exampleResolverFirewallRuleGroup.id}
 *       priority: 100
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import  Route 53 Resolver DNS Firewall rules using the Route 53 Resolver DNS Firewall rule group ID and domain list ID separated by ':'. For example:
 * ```sh
 * $ pulumi import aws:route53/resolverFirewallRule:ResolverFirewallRule example rslvr-frg-0123456789abcdef:rslvr-fdl-0123456789abcdef
 * ```
 * @property action The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
 * @property blockOverrideDnsType The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
 * @property blockOverrideDomain The custom DNS record to send back in response to the query.
 * @property blockOverrideTtl The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
 * @property blockResponse The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
 * @property firewallDomainListId The ID of the domain list that you want to use in the rule.
 * @property firewallDomainRedirectionAction Evaluate DNS redirection in the DNS redirection chain, such as CNAME, DNAME, ot ALIAS. Valid values are `INSPECT_REDIRECTION_DOMAIN` and `TRUST_REDIRECTION_DOMAIN`. Default value is `INSPECT_REDIRECTION_DOMAIN`.
 * @property firewallRuleGroupId The unique identifier of the firewall rule group where you want to create the rule.
 * @property name A name that lets you identify the rule, to manage and use it.
 * @property priority The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
 * @property qType The query type you want the rule to evaluate. Additional details can be found [here](https://en.wikipedia.org/wiki/List_of_DNS_record_types)
 */
public data class ResolverFirewallRuleArgs(
    public val action: Output<String>? = null,
    public val blockOverrideDnsType: Output<String>? = null,
    public val blockOverrideDomain: Output<String>? = null,
    public val blockOverrideTtl: Output<Int>? = null,
    public val blockResponse: Output<String>? = null,
    public val firewallDomainListId: Output<String>? = null,
    public val firewallDomainRedirectionAction: Output<String>? = null,
    public val firewallRuleGroupId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val qType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverFirewallRuleArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverFirewallRuleArgs =
        com.pulumi.aws.route53.ResolverFirewallRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .blockOverrideDnsType(blockOverrideDnsType?.applyValue({ args0 -> args0 }))
            .blockOverrideDomain(blockOverrideDomain?.applyValue({ args0 -> args0 }))
            .blockOverrideTtl(blockOverrideTtl?.applyValue({ args0 -> args0 }))
            .blockResponse(blockResponse?.applyValue({ args0 -> args0 }))
            .firewallDomainListId(firewallDomainListId?.applyValue({ args0 -> args0 }))
            .firewallDomainRedirectionAction(firewallDomainRedirectionAction?.applyValue({ args0 -> args0 }))
            .firewallRuleGroupId(firewallRuleGroupId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .qType(qType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverFirewallRuleArgs].
 */
@PulumiTagMarker
public class ResolverFirewallRuleArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var blockOverrideDnsType: Output<String>? = null

    private var blockOverrideDomain: Output<String>? = null

    private var blockOverrideTtl: Output<Int>? = null

    private var blockResponse: Output<String>? = null

    private var firewallDomainListId: Output<String>? = null

    private var firewallDomainRedirectionAction: Output<String>? = null

    private var firewallRuleGroupId: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var qType: Output<String>? = null

    /**
     * @param value The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
     */
    @JvmName("ljyblgqjwmtpwxlx")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
     */
    @JvmName("brjvvduwglsyeohh")
    public suspend fun blockOverrideDnsType(`value`: Output<String>) {
        this.blockOverrideDnsType = value
    }

    /**
     * @param value The custom DNS record to send back in response to the query.
     */
    @JvmName("teaqwdyxyuhbgmmb")
    public suspend fun blockOverrideDomain(`value`: Output<String>) {
        this.blockOverrideDomain = value
    }

    /**
     * @param value The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
     */
    @JvmName("extlxidyuydubooa")
    public suspend fun blockOverrideTtl(`value`: Output<Int>) {
        this.blockOverrideTtl = value
    }

    /**
     * @param value The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
     */
    @JvmName("dpxiuorjrigfsljt")
    public suspend fun blockResponse(`value`: Output<String>) {
        this.blockResponse = value
    }

    /**
     * @param value The ID of the domain list that you want to use in the rule.
     */
    @JvmName("ctlnvtmxenttvocx")
    public suspend fun firewallDomainListId(`value`: Output<String>) {
        this.firewallDomainListId = value
    }

    /**
     * @param value Evaluate DNS redirection in the DNS redirection chain, such as CNAME, DNAME, ot ALIAS. Valid values are `INSPECT_REDIRECTION_DOMAIN` and `TRUST_REDIRECTION_DOMAIN`. Default value is `INSPECT_REDIRECTION_DOMAIN`.
     */
    @JvmName("jfdhxkxjcsiwuoji")
    public suspend fun firewallDomainRedirectionAction(`value`: Output<String>) {
        this.firewallDomainRedirectionAction = value
    }

    /**
     * @param value The unique identifier of the firewall rule group where you want to create the rule.
     */
    @JvmName("rfuuplgoifcxvmdv")
    public suspend fun firewallRuleGroupId(`value`: Output<String>) {
        this.firewallRuleGroupId = value
    }

    /**
     * @param value A name that lets you identify the rule, to manage and use it.
     */
    @JvmName("nbbvfscnwyhuyhsu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     */
    @JvmName("swiknraccttucyme")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The query type you want the rule to evaluate. Additional details can be found [here](https://en.wikipedia.org/wiki/List_of_DNS_record_types)
     */
    @JvmName("proguhxgecfqunho")
    public suspend fun qType(`value`: Output<String>) {
        this.qType = value
    }

    /**
     * @param value The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
     */
    @JvmName("ewchntlgkeddamex")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
     */
    @JvmName("nvguqwlnrtshetus")
    public suspend fun blockOverrideDnsType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockOverrideDnsType = mapped
    }

    /**
     * @param value The custom DNS record to send back in response to the query.
     */
    @JvmName("uirtvkyuqexvvpbk")
    public suspend fun blockOverrideDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockOverrideDomain = mapped
    }

    /**
     * @param value The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
     */
    @JvmName("nnegrkieujbbvrkf")
    public suspend fun blockOverrideTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockOverrideTtl = mapped
    }

    /**
     * @param value The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
     */
    @JvmName("fpwmiypgfjpgyohc")
    public suspend fun blockResponse(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockResponse = mapped
    }

    /**
     * @param value The ID of the domain list that you want to use in the rule.
     */
    @JvmName("qqbcfwckvnahgfsn")
    public suspend fun firewallDomainListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallDomainListId = mapped
    }

    /**
     * @param value Evaluate DNS redirection in the DNS redirection chain, such as CNAME, DNAME, ot ALIAS. Valid values are `INSPECT_REDIRECTION_DOMAIN` and `TRUST_REDIRECTION_DOMAIN`. Default value is `INSPECT_REDIRECTION_DOMAIN`.
     */
    @JvmName("hjngtnlbkqnrjlrf")
    public suspend fun firewallDomainRedirectionAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallDomainRedirectionAction = mapped
    }

    /**
     * @param value The unique identifier of the firewall rule group where you want to create the rule.
     */
    @JvmName("iytgsvyhbdrbqysk")
    public suspend fun firewallRuleGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRuleGroupId = mapped
    }

    /**
     * @param value A name that lets you identify the rule, to manage and use it.
     */
    @JvmName("ghvblrmsclxwescx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     */
    @JvmName("lewcktlvfivychse")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The query type you want the rule to evaluate. Additional details can be found [here](https://en.wikipedia.org/wiki/List_of_DNS_record_types)
     */
    @JvmName("dobeuqbhnqlfdors")
    public suspend fun qType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qType = mapped
    }

    internal fun build(): ResolverFirewallRuleArgs = ResolverFirewallRuleArgs(
        action = action,
        blockOverrideDnsType = blockOverrideDnsType,
        blockOverrideDomain = blockOverrideDomain,
        blockOverrideTtl = blockOverrideTtl,
        blockResponse = blockResponse,
        firewallDomainListId = firewallDomainListId,
        firewallDomainRedirectionAction = firewallDomainRedirectionAction,
        firewallRuleGroupId = firewallRuleGroupId,
        name = name,
        priority = priority,
        qType = qType,
    )
}
