@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResolverQueryLogConfigAssociation].
 */
@PulumiTagMarker
public class ResolverQueryLogConfigAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverQueryLogConfigAssociationArgs = ResolverQueryLogConfigAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverQueryLogConfigAssociationArgsBuilder.() -> Unit) {
        val builder = ResolverQueryLogConfigAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResolverQueryLogConfigAssociation {
        val builtJavaResource =
            com.pulumi.aws.route53.ResolverQueryLogConfigAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResolverQueryLogConfigAssociation(builtJavaResource)
    }
}

/**
 * Provides a Route 53 Resolver query logging configuration association resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.ResolverQueryLogConfigAssociation("example", {
 *     resolverQueryLogConfigId: exampleAwsRoute53ResolverQueryLogConfig.id,
 *     resourceId: exampleAwsVpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.ResolverQueryLogConfigAssociation("example",
 *     resolver_query_log_config_id=example_aws_route53_resolver_query_log_config["id"],
 *     resource_id=example_aws_vpc["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.ResolverQueryLogConfigAssociation("example", new()
 *     {
 *         ResolverQueryLogConfigId = exampleAwsRoute53ResolverQueryLogConfig.Id,
 *         ResourceId = exampleAwsVpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewResolverQueryLogConfigAssociation(ctx, "example", &route53.ResolverQueryLogConfigAssociationArgs{
 * 			ResolverQueryLogConfigId: pulumi.Any(exampleAwsRoute53ResolverQueryLogConfig.Id),
 * 			ResourceId:               pulumi.Any(exampleAwsVpc.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverQueryLogConfigAssociation;
 * import com.pulumi.aws.route53.ResolverQueryLogConfigAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResolverQueryLogConfigAssociation("example", ResolverQueryLogConfigAssociationArgs.builder()
 *             .resolverQueryLogConfigId(exampleAwsRoute53ResolverQueryLogConfig.id())
 *             .resourceId(exampleAwsVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:ResolverQueryLogConfigAssociation
 *     properties:
 *       resolverQueryLogConfigId: ${exampleAwsRoute53ResolverQueryLogConfig.id}
 *       resourceId: ${exampleAwsVpc.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import  Route 53 Resolver query logging configuration associations using the Route 53 Resolver query logging configuration association ID. For example:
 * ```sh
 * $ pulumi import aws:route53/resolverQueryLogConfigAssociation:ResolverQueryLogConfigAssociation example rqlca-b320624fef3c4d70
 * ```
 */
public class ResolverQueryLogConfigAssociation internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverQueryLogConfigAssociation,
) : KotlinCustomResource(javaResource, ResolverQueryLogConfigAssociationMapper) {
    /**
     * The ID of the Route 53 Resolver query logging configuration that you want to associate a VPC with.
     */
    public val resolverQueryLogConfigId: Output<String>
        get() = javaResource.resolverQueryLogConfigId().applyValue({ args0 -> args0 })

    /**
     * The ID of a VPC that you want this query logging configuration to log queries for.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })
}

public object ResolverQueryLogConfigAssociationMapper :
    ResourceMapper<ResolverQueryLogConfigAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverQueryLogConfigAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ResolverQueryLogConfigAssociation =
        ResolverQueryLogConfigAssociation(
            javaResource as
                com.pulumi.aws.route53.ResolverQueryLogConfigAssociation,
        )
}

/**
 * @see [ResolverQueryLogConfigAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverQueryLogConfigAssociation].
 */
public suspend fun resolverQueryLogConfigAssociation(
    name: String,
    block: suspend ResolverQueryLogConfigAssociationResourceBuilder.() -> Unit,
): ResolverQueryLogConfigAssociation {
    val builder = ResolverQueryLogConfigAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverQueryLogConfigAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverQueryLogConfigAssociation(name: String): ResolverQueryLogConfigAssociation {
    val builder = ResolverQueryLogConfigAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
