@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverQueryLogConfigAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route 53 Resolver query logging configuration association resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.ResolverQueryLogConfigAssociation("example", {
 *     resolverQueryLogConfigId: exampleAwsRoute53ResolverQueryLogConfig.id,
 *     resourceId: exampleAwsVpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.ResolverQueryLogConfigAssociation("example",
 *     resolver_query_log_config_id=example_aws_route53_resolver_query_log_config["id"],
 *     resource_id=example_aws_vpc["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.ResolverQueryLogConfigAssociation("example", new()
 *     {
 *         ResolverQueryLogConfigId = exampleAwsRoute53ResolverQueryLogConfig.Id,
 *         ResourceId = exampleAwsVpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewResolverQueryLogConfigAssociation(ctx, "example", &route53.ResolverQueryLogConfigAssociationArgs{
 * 			ResolverQueryLogConfigId: pulumi.Any(exampleAwsRoute53ResolverQueryLogConfig.Id),
 * 			ResourceId:               pulumi.Any(exampleAwsVpc.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverQueryLogConfigAssociation;
 * import com.pulumi.aws.route53.ResolverQueryLogConfigAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResolverQueryLogConfigAssociation("example", ResolverQueryLogConfigAssociationArgs.builder()
 *             .resolverQueryLogConfigId(exampleAwsRoute53ResolverQueryLogConfig.id())
 *             .resourceId(exampleAwsVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:ResolverQueryLogConfigAssociation
 *     properties:
 *       resolverQueryLogConfigId: ${exampleAwsRoute53ResolverQueryLogConfig.id}
 *       resourceId: ${exampleAwsVpc.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import  Route 53 Resolver query logging configuration associations using the Route 53 Resolver query logging configuration association ID. For example:
 * ```sh
 * $ pulumi import aws:route53/resolverQueryLogConfigAssociation:ResolverQueryLogConfigAssociation example rqlca-b320624fef3c4d70
 * ```
 * @property resolverQueryLogConfigId The ID of the Route 53 Resolver query logging configuration that you want to associate a VPC with.
 * @property resourceId The ID of a VPC that you want this query logging configuration to log queries for.
 */
public data class ResolverQueryLogConfigAssociationArgs(
    public val resolverQueryLogConfigId: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverQueryLogConfigAssociationArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverQueryLogConfigAssociationArgs =
        com.pulumi.aws.route53.ResolverQueryLogConfigAssociationArgs.builder()
            .resolverQueryLogConfigId(resolverQueryLogConfigId?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverQueryLogConfigAssociationArgs].
 */
@PulumiTagMarker
public class ResolverQueryLogConfigAssociationArgsBuilder internal constructor() {
    private var resolverQueryLogConfigId: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value The ID of the Route 53 Resolver query logging configuration that you want to associate a VPC with.
     */
    @JvmName("bbbinbomrbjowsmd")
    public suspend fun resolverQueryLogConfigId(`value`: Output<String>) {
        this.resolverQueryLogConfigId = value
    }

    /**
     * @param value The ID of a VPC that you want this query logging configuration to log queries for.
     */
    @JvmName("obqevryohcmxonra")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The ID of the Route 53 Resolver query logging configuration that you want to associate a VPC with.
     */
    @JvmName("ppqexxaajaykreha")
    public suspend fun resolverQueryLogConfigId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolverQueryLogConfigId = mapped
    }

    /**
     * @param value The ID of a VPC that you want this query logging configuration to log queries for.
     */
    @JvmName("aqtqjdtbpcjrosfe")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ResolverQueryLogConfigAssociationArgs =
        ResolverQueryLogConfigAssociationArgs(
            resolverQueryLogConfigId = resolverQueryLogConfigId,
            resourceId = resourceId,
        )
}
