@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.kotlin.outputs.ResolverRuleTargetIp
import com.pulumi.aws.route53.kotlin.outputs.ResolverRuleTargetIp.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ResolverRule].
 */
@PulumiTagMarker
public class ResolverRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverRuleArgs = ResolverRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverRuleArgsBuilder.() -> Unit) {
        val builder = ResolverRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResolverRule {
        val builtJavaResource = com.pulumi.aws.route53.ResolverRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResolverRule(builtJavaResource)
    }
}

/**
 * Provides a Route53 Resolver rule.
 * ## Example Usage
 * ### System rule
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sys = new aws.route53.ResolverRule("sys", {
 *     domainName: "subdomain.example.com",
 *     ruleType: "SYSTEM",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sys = aws.route53.ResolverRule("sys",
 *     domain_name="subdomain.example.com",
 *     rule_type="SYSTEM")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sys = new Aws.Route53.ResolverRule("sys", new()
 *     {
 *         DomainName = "subdomain.example.com",
 *         RuleType = "SYSTEM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewResolverRule(ctx, "sys", &route53.ResolverRuleArgs{
 * 			DomainName: pulumi.String("subdomain.example.com"),
 * 			RuleType:   pulumi.String("SYSTEM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverRule;
 * import com.pulumi.aws.route53.ResolverRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sys = new ResolverRule("sys", ResolverRuleArgs.builder()
 *             .domainName("subdomain.example.com")
 *             .ruleType("SYSTEM")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sys:
 *     type: aws:route53:ResolverRule
 *     properties:
 *       domainName: subdomain.example.com
 *       ruleType: SYSTEM
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Forward rule
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const fwd = new aws.route53.ResolverRule("fwd", {
 *     domainName: "example.com",
 *     name: "example",
 *     ruleType: "FORWARD",
 *     resolverEndpointId: foo.id,
 *     targetIps: [{
 *         ip: "123.45.67.89",
 *     }],
 *     tags: {
 *         Environment: "Prod",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * fwd = aws.route53.ResolverRule("fwd",
 *     domain_name="example.com",
 *     name="example",
 *     rule_type="FORWARD",
 *     resolver_endpoint_id=foo["id"],
 *     target_ips=[{
 *         "ip": "123.45.67.89",
 *     }],
 *     tags={
 *         "Environment": "Prod",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fwd = new Aws.Route53.ResolverRule("fwd", new()
 *     {
 *         DomainName = "example.com",
 *         Name = "example",
 *         RuleType = "FORWARD",
 *         ResolverEndpointId = foo.Id,
 *         TargetIps = new[]
 *         {
 *             new Aws.Route53.Inputs.ResolverRuleTargetIpArgs
 *             {
 *                 Ip = "123.45.67.89",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "Prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewResolverRule(ctx, "fwd", &route53.ResolverRuleArgs{
 * 			DomainName:         pulumi.String("example.com"),
 * 			Name:               pulumi.String("example"),
 * 			RuleType:           pulumi.String("FORWARD"),
 * 			ResolverEndpointId: pulumi.Any(foo.Id),
 * 			TargetIps: route53.ResolverRuleTargetIpArray{
 * 				&route53.ResolverRuleTargetIpArgs{
 * 					Ip: pulumi.String("123.45.67.89"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverRule;
 * import com.pulumi.aws.route53.ResolverRuleArgs;
 * import com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fwd = new ResolverRule("fwd", ResolverRuleArgs.builder()
 *             .domainName("example.com")
 *             .name("example")
 *             .ruleType("FORWARD")
 *             .resolverEndpointId(foo.id())
 *             .targetIps(ResolverRuleTargetIpArgs.builder()
 *                 .ip("123.45.67.89")
 *                 .build())
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fwd:
 *     type: aws:route53:ResolverRule
 *     properties:
 *       domainName: example.com
 *       name: example
 *       ruleType: FORWARD
 *       resolverEndpointId: ${foo.id}
 *       targetIps:
 *         - ip: 123.45.67.89
 *       tags:
 *         Environment: Prod
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Resolver rules using the `id`. For example:
 * ```sh
 * $ pulumi import aws:route53/resolverRule:ResolverRule sys rslvr-rr-0123456789abcdef0
 * ```
 */
public class ResolverRule internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverRule,
) : KotlinCustomResource(javaResource, ResolverRuleMapper) {
    /**
     * The ARN (Amazon Resource Name) for the resolver rule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * DNS queries for this domain name are forwarded to the IP addresses that are specified using `target_ip`.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * When a rule is shared with another AWS account, the account ID of the account that the rule is shared with.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify using `target_ip`.
     * This argument should only be specified for `FORWARD` type rules.
     */
    public val resolverEndpointId: Output<String>?
        get() = javaResource.resolverEndpointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The rule type. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
     */
    public val ruleType: Output<String>
        get() = javaResource.ruleType().applyValue({ args0 -> args0 })

    /**
     * Whether the rules is shared and, if so, whether the current account is sharing the rule with another account, or another account is sharing the rule with the current account.
     * Values are `NOT_SHARED`, `SHARED_BY_ME` or `SHARED_WITH_ME`
     */
    public val shareStatus: Output<String>
        get() = javaResource.shareStatus().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    public val targetIps: Output<List<ResolverRuleTargetIp>>?
        get() = javaResource.targetIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object ResolverRuleMapper : ResourceMapper<ResolverRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverRule::class == javaResource::class

    override fun map(javaResource: Resource): ResolverRule = ResolverRule(
        javaResource as
            com.pulumi.aws.route53.ResolverRule,
    )
}

/**
 * @see [ResolverRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverRule].
 */
public suspend fun resolverRule(
    name: String,
    block: suspend ResolverRuleResourceBuilder.() -> Unit,
): ResolverRule {
    val builder = ResolverRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverRule(name: String): ResolverRule {
    val builder = ResolverRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
