@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverRuleArgs.builder
import com.pulumi.aws.route53.kotlin.inputs.ResolverRuleTargetIpArgs
import com.pulumi.aws.route53.kotlin.inputs.ResolverRuleTargetIpArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Route53 Resolver rule.
 * ## Example Usage
 * ### System rule
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sys = new aws.route53.ResolverRule("sys", {
 *     domainName: "subdomain.example.com",
 *     ruleType: "SYSTEM",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sys = aws.route53.ResolverRule("sys",
 *     domain_name="subdomain.example.com",
 *     rule_type="SYSTEM")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sys = new Aws.Route53.ResolverRule("sys", new()
 *     {
 *         DomainName = "subdomain.example.com",
 *         RuleType = "SYSTEM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewResolverRule(ctx, "sys", &route53.ResolverRuleArgs{
 * 			DomainName: pulumi.String("subdomain.example.com"),
 * 			RuleType:   pulumi.String("SYSTEM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverRule;
 * import com.pulumi.aws.route53.ResolverRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sys = new ResolverRule("sys", ResolverRuleArgs.builder()
 *             .domainName("subdomain.example.com")
 *             .ruleType("SYSTEM")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sys:
 *     type: aws:route53:ResolverRule
 *     properties:
 *       domainName: subdomain.example.com
 *       ruleType: SYSTEM
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Forward rule
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const fwd = new aws.route53.ResolverRule("fwd", {
 *     domainName: "example.com",
 *     name: "example",
 *     ruleType: "FORWARD",
 *     resolverEndpointId: foo.id,
 *     targetIps: [{
 *         ip: "123.45.67.89",
 *     }],
 *     tags: {
 *         Environment: "Prod",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * fwd = aws.route53.ResolverRule("fwd",
 *     domain_name="example.com",
 *     name="example",
 *     rule_type="FORWARD",
 *     resolver_endpoint_id=foo["id"],
 *     target_ips=[{
 *         "ip": "123.45.67.89",
 *     }],
 *     tags={
 *         "Environment": "Prod",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fwd = new Aws.Route53.ResolverRule("fwd", new()
 *     {
 *         DomainName = "example.com",
 *         Name = "example",
 *         RuleType = "FORWARD",
 *         ResolverEndpointId = foo.Id,
 *         TargetIps = new[]
 *         {
 *             new Aws.Route53.Inputs.ResolverRuleTargetIpArgs
 *             {
 *                 Ip = "123.45.67.89",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "Prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewResolverRule(ctx, "fwd", &route53.ResolverRuleArgs{
 * 			DomainName:         pulumi.String("example.com"),
 * 			Name:               pulumi.String("example"),
 * 			RuleType:           pulumi.String("FORWARD"),
 * 			ResolverEndpointId: pulumi.Any(foo.Id),
 * 			TargetIps: route53.ResolverRuleTargetIpArray{
 * 				&route53.ResolverRuleTargetIpArgs{
 * 					Ip: pulumi.String("123.45.67.89"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverRule;
 * import com.pulumi.aws.route53.ResolverRuleArgs;
 * import com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fwd = new ResolverRule("fwd", ResolverRuleArgs.builder()
 *             .domainName("example.com")
 *             .name("example")
 *             .ruleType("FORWARD")
 *             .resolverEndpointId(foo.id())
 *             .targetIps(ResolverRuleTargetIpArgs.builder()
 *                 .ip("123.45.67.89")
 *                 .build())
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fwd:
 *     type: aws:route53:ResolverRule
 *     properties:
 *       domainName: example.com
 *       name: example
 *       ruleType: FORWARD
 *       resolverEndpointId: ${foo.id}
 *       targetIps:
 *         - ip: 123.45.67.89
 *       tags:
 *         Environment: Prod
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Resolver rules using the `id`. For example:
 * ```sh
 * $ pulumi import aws:route53/resolverRule:ResolverRule sys rslvr-rr-0123456789abcdef0
 * ```
 * @property domainName DNS queries for this domain name are forwarded to the IP addresses that are specified using `target_ip`.
 * @property name A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
 * @property resolverEndpointId The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify using `target_ip`.
 * This argument should only be specified for `FORWARD` type rules.
 * @property ruleType The rule type. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetIps Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
 * This argument should only be specified for `FORWARD` type rules.
 */
public data class ResolverRuleArgs(
    public val domainName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resolverEndpointId: Output<String>? = null,
    public val ruleType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetIps: Output<List<ResolverRuleTargetIpArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverRuleArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverRuleArgs =
        com.pulumi.aws.route53.ResolverRuleArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resolverEndpointId(resolverEndpointId?.applyValue({ args0 -> args0 }))
            .ruleType(ruleType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetIps(
                targetIps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResolverRuleArgs].
 */
@PulumiTagMarker
public class ResolverRuleArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var name: Output<String>? = null

    private var resolverEndpointId: Output<String>? = null

    private var ruleType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetIps: Output<List<ResolverRuleTargetIpArgs>>? = null

    /**
     * @param value DNS queries for this domain name are forwarded to the IP addresses that are specified using `target_ip`.
     */
    @JvmName("mtdvstubdfxscbni")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
     */
    @JvmName("avtivqmiycydhxch")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify using `target_ip`.
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("mmqbvosscnqicoqf")
    public suspend fun resolverEndpointId(`value`: Output<String>) {
        this.resolverEndpointId = value
    }

    /**
     * @param value The rule type. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
     */
    @JvmName("mlccsmficajoonaw")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("otpsmmbpptxevpao")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("wdmpetiojxwkgttb")
    public suspend fun targetIps(`value`: Output<List<ResolverRuleTargetIpArgs>>) {
        this.targetIps = value
    }

    @JvmName("vansptwyvkplcfks")
    public suspend fun targetIps(vararg values: Output<ResolverRuleTargetIpArgs>) {
        this.targetIps = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("locphosvahlkqush")
    public suspend fun targetIps(values: List<Output<ResolverRuleTargetIpArgs>>) {
        this.targetIps = Output.all(values)
    }

    /**
     * @param value DNS queries for this domain name are forwarded to the IP addresses that are specified using `target_ip`.
     */
    @JvmName("plbmwrhdticbjqlq")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
     */
    @JvmName("xcwwstpkibwddlns")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify using `target_ip`.
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("hfjrktjrgkkjjhqw")
    public suspend fun resolverEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolverEndpointId = mapped
    }

    /**
     * @param value The rule type. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
     */
    @JvmName("fmhatiiuwriedvxu")
    public suspend fun ruleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ufglapaoyqwcftci")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bdmgwjefetwppqal")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("gddondhcgqbpglxn")
    public suspend fun targetIps(`value`: List<ResolverRuleTargetIpArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetIps = mapped
    }

    /**
     * @param argument Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("qxkwvdalhrouwikq")
    public suspend fun targetIps(argument: List<suspend ResolverRuleTargetIpArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResolverRuleTargetIpArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetIps = mapped
    }

    /**
     * @param argument Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("mdrfslbuaoukttom")
    public suspend fun targetIps(vararg argument: suspend ResolverRuleTargetIpArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResolverRuleTargetIpArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetIps = mapped
    }

    /**
     * @param argument Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("ucusbxoigtlpbtyr")
    public suspend fun targetIps(argument: suspend ResolverRuleTargetIpArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResolverRuleTargetIpArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetIps = mapped
    }

    /**
     * @param values Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("uqgkcxsrfkgabcqk")
    public suspend fun targetIps(vararg values: ResolverRuleTargetIpArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetIps = mapped
    }

    internal fun build(): ResolverRuleArgs = ResolverRuleArgs(
        domainName = domainName,
        name = name,
        resolverEndpointId = resolverEndpointId,
        ruleType = ruleType,
        tags = tags,
        targetIps = targetIps,
    )
}
