@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverRuleAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route53 Resolver rule association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.ResolverRuleAssociation("example", {
 *     resolverRuleId: sys.id,
 *     vpcId: foo.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.ResolverRuleAssociation("example",
 *     resolver_rule_id=sys["id"],
 *     vpc_id=foo["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.ResolverRuleAssociation("example", new()
 *     {
 *         ResolverRuleId = sys.Id,
 *         VpcId = foo.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewResolverRuleAssociation(ctx, "example", &route53.ResolverRuleAssociationArgs{
 * 			ResolverRuleId: pulumi.Any(sys.Id),
 * 			VpcId:          pulumi.Any(foo.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverRuleAssociation;
 * import com.pulumi.aws.route53.ResolverRuleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResolverRuleAssociation("example", ResolverRuleAssociationArgs.builder()
 *             .resolverRuleId(sys.id())
 *             .vpcId(foo.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:ResolverRuleAssociation
 *     properties:
 *       resolverRuleId: ${sys.id}
 *       vpcId: ${foo.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Resolver rule associations using the `id`. For example:
 * ```sh
 * $ pulumi import aws:route53/resolverRuleAssociation:ResolverRuleAssociation example rslvr-rrassoc-97242eaf88example
 * ```
 * @property name A name for the association that you're creating between a resolver rule and a VPC.
 * @property resolverRuleId The ID of the resolver rule that you want to associate with the VPC.
 * @property vpcId The ID of the VPC that you want to associate the resolver rule with.
 */
public data class ResolverRuleAssociationArgs(
    public val name: Output<String>? = null,
    public val resolverRuleId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverRuleAssociationArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverRuleAssociationArgs =
        com.pulumi.aws.route53.ResolverRuleAssociationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .resolverRuleId(resolverRuleId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverRuleAssociationArgs].
 */
@PulumiTagMarker
public class ResolverRuleAssociationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var resolverRuleId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value A name for the association that you're creating between a resolver rule and a VPC.
     */
    @JvmName("otojbtcmwagcbexh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the resolver rule that you want to associate with the VPC.
     */
    @JvmName("grsmunvtjddwfnmp")
    public suspend fun resolverRuleId(`value`: Output<String>) {
        this.resolverRuleId = value
    }

    /**
     * @param value The ID of the VPC that you want to associate the resolver rule with.
     */
    @JvmName("pylpvyyrpxncdjbf")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value A name for the association that you're creating between a resolver rule and a VPC.
     */
    @JvmName("vtoneqgkaowtpflv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the resolver rule that you want to associate with the VPC.
     */
    @JvmName("lunegalvomfroebr")
    public suspend fun resolverRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolverRuleId = mapped
    }

    /**
     * @param value The ID of the VPC that you want to associate the resolver rule with.
     */
    @JvmName("pvbttjqckvcbfwkw")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ResolverRuleAssociationArgs = ResolverRuleAssociationArgs(
        name = name,
        resolverRuleId = resolverRuleId,
        vpcId = vpcId,
    )
}
