@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrafficPolicy].
 */
@PulumiTagMarker
public class TrafficPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficPolicyArgs = TrafficPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficPolicyArgsBuilder.() -> Unit) {
        val builder = TrafficPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrafficPolicy {
        val builtJavaResource = com.pulumi.aws.route53.TrafficPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrafficPolicy(builtJavaResource)
    }
}

/**
 * Manages a Route53 Traffic Policy.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.route53.TrafficPolicy("example", {
 *     name: "example",
 *     comment: "example comment",
 *     document: `{
 *   "AWSPolicyFormatVersion": "2015-10-01",
 *   "RecordType": "A",
 *   "Endpoints": {
 *     "endpoint-start-NkPh": {
 *       "Type": "value",
 *       "Value": "10.0.0.2"
 *     }
 *   },
 *   "StartEndpoint": "endpoint-start-NkPh"
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.route53.TrafficPolicy("example",
 *     name="example",
 *     comment="example comment",
 *     document="""{
 *   "AWSPolicyFormatVersion": "2015-10-01",
 *   "RecordType": "A",
 *   "Endpoints": {
 *     "endpoint-start-NkPh": {
 *       "Type": "value",
 *       "Value": "10.0.0.2"
 *     }
 *   },
 *   "StartEndpoint": "endpoint-start-NkPh"
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Route53.TrafficPolicy("example", new()
 *     {
 *         Name = "example",
 *         Comment = "example comment",
 *         Document = @"{
 *   ""AWSPolicyFormatVersion"": ""2015-10-01"",
 *   ""RecordType"": ""A"",
 *   ""Endpoints"": {
 *     ""endpoint-start-NkPh"": {
 *       ""Type"": ""value"",
 *       ""Value"": ""10.0.0.2""
 *     }
 *   },
 *   ""StartEndpoint"": ""endpoint-start-NkPh""
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewTrafficPolicy(ctx, "example", &route53.TrafficPolicyArgs{
 * 			Name:    pulumi.String("example"),
 * 			Comment: pulumi.String("example comment"),
 * 			Document: pulumi.String(`{
 *   "AWSPolicyFormatVersion": "2015-10-01",
 *   "RecordType": "A",
 *   "Endpoints": {
 *     "endpoint-start-NkPh": {
 *       "Type": "value",
 *       "Value": "10.0.0.2"
 *     }
 *   },
 *   "StartEndpoint": "endpoint-start-NkPh"
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.TrafficPolicy;
 * import com.pulumi.aws.route53.TrafficPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TrafficPolicy("example", TrafficPolicyArgs.builder()
 *             .name("example")
 *             .comment("example comment")
 *             .document("""
 * {
 *   "AWSPolicyFormatVersion": "2015-10-01",
 *   "RecordType": "A",
 *   "Endpoints": {
 *     "endpoint-start-NkPh": {
 *       "Type": "value",
 *       "Value": "10.0.0.2"
 *     }
 *   },
 *   "StartEndpoint": "endpoint-start-NkPh"
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:route53:TrafficPolicy
 *     properties:
 *       name: example
 *       comment: example comment
 *       document: |
 *         {
 *           "AWSPolicyFormatVersion": "2015-10-01",
 *           "RecordType": "A",
 *           "Endpoints": {
 *             "endpoint-start-NkPh": {
 *               "Type": "value",
 *               "Value": "10.0.0.2"
 *             }
 *           },
 *           "StartEndpoint": "endpoint-start-NkPh"
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 Traffic Policy using the `id` and `version`. For example:
 * ```sh
 * $ pulumi import aws:route53/trafficPolicy:TrafficPolicy example 01a52019-d16f-422a-ae72-c306d2b6df7e/1
 * ```
 */
public class TrafficPolicy internal constructor(
    override val javaResource: com.pulumi.aws.route53.TrafficPolicy,
) : KotlinCustomResource(javaResource, TrafficPolicyMapper) {
    /**
     * Comment for the traffic policy.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Policy document. This is a JSON formatted string. For more information about building Route53 traffic policy documents, see the [AWS Route53 Traffic Policy document format](https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html)
     * The following arguments are optional:
     */
    public val document: Output<String>
        get() = javaResource.document().applyValue({ args0 -> args0 })

    /**
     * Name of the traffic policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a traffic policy instance.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version number of the traffic policy. This value is automatically incremented by AWS after each update of this resource.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object TrafficPolicyMapper : ResourceMapper<TrafficPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.TrafficPolicy::class == javaResource::class

    override fun map(javaResource: Resource): TrafficPolicy = TrafficPolicy(
        javaResource as
            com.pulumi.aws.route53.TrafficPolicy,
    )
}

/**
 * @see [TrafficPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficPolicy].
 */
public suspend fun trafficPolicy(
    name: String,
    block: suspend TrafficPolicyResourceBuilder.() -> Unit,
): TrafficPolicy {
    val builder = TrafficPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficPolicy(name: String): TrafficPolicy {
    val builder = TrafficPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
