@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrafficPolicyInstance].
 */
@PulumiTagMarker
public class TrafficPolicyInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficPolicyInstanceArgs = TrafficPolicyInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficPolicyInstanceArgsBuilder.() -> Unit) {
        val builder = TrafficPolicyInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrafficPolicyInstance {
        val builtJavaResource = com.pulumi.aws.route53.TrafficPolicyInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrafficPolicyInstance(builtJavaResource)
    }
}

/**
 * Provides a Route53 traffic policy instance resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.route53.TrafficPolicyInstance("test", {
 *     name: "test.example.com",
 *     trafficPolicyId: "b3gb108f-ea6f-45a5-baab-9d112d8b4037",
 *     trafficPolicyVersion: 1,
 *     hostedZoneId: "Z033120931TAQO548OGJC",
 *     ttl: 360,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.route53.TrafficPolicyInstance("test",
 *     name="test.example.com",
 *     traffic_policy_id="b3gb108f-ea6f-45a5-baab-9d112d8b4037",
 *     traffic_policy_version=1,
 *     hosted_zone_id="Z033120931TAQO548OGJC",
 *     ttl=360)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Route53.TrafficPolicyInstance("test", new()
 *     {
 *         Name = "test.example.com",
 *         TrafficPolicyId = "b3gb108f-ea6f-45a5-baab-9d112d8b4037",
 *         TrafficPolicyVersion = 1,
 *         HostedZoneId = "Z033120931TAQO548OGJC",
 *         Ttl = 360,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewTrafficPolicyInstance(ctx, "test", &route53.TrafficPolicyInstanceArgs{
 * 			Name:                 pulumi.String("test.example.com"),
 * 			TrafficPolicyId:      pulumi.String("b3gb108f-ea6f-45a5-baab-9d112d8b4037"),
 * 			TrafficPolicyVersion: pulumi.Int(1),
 * 			HostedZoneId:         pulumi.String("Z033120931TAQO548OGJC"),
 * 			Ttl:                  pulumi.Int(360),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.TrafficPolicyInstance;
 * import com.pulumi.aws.route53.TrafficPolicyInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TrafficPolicyInstance("test", TrafficPolicyInstanceArgs.builder()
 *             .name("test.example.com")
 *             .trafficPolicyId("b3gb108f-ea6f-45a5-baab-9d112d8b4037")
 *             .trafficPolicyVersion(1)
 *             .hostedZoneId("Z033120931TAQO548OGJC")
 *             .ttl(360)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:route53:TrafficPolicyInstance
 *     properties:
 *       name: test.example.com
 *       trafficPolicyId: b3gb108f-ea6f-45a5-baab-9d112d8b4037
 *       trafficPolicyVersion: 1
 *       hostedZoneId: Z033120931TAQO548OGJC
 *       ttl: 360
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 traffic policy instance using its id. For example:
 * ```sh
 * $ pulumi import aws:route53/trafficPolicyInstance:TrafficPolicyInstance test df579d9a-6396-410e-ac22-e7ad60cf9e7e
 * ```
 */
public class TrafficPolicyInstance internal constructor(
    override val javaResource: com.pulumi.aws.route53.TrafficPolicyInstance,
) : KotlinCustomResource(javaResource, TrafficPolicyInstanceMapper) {
    /**
     * ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    /**
     * Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
     */
    public val trafficPolicyId: Output<String>
        get() = javaResource.trafficPolicyId().applyValue({ args0 -> args0 })

    /**
     * Version of the traffic policy
     */
    public val trafficPolicyVersion: Output<Int>
        get() = javaResource.trafficPolicyVersion().applyValue({ args0 -> args0 })

    /**
     * TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
     */
    public val ttl: Output<Int>
        get() = javaResource.ttl().applyValue({ args0 -> args0 })
}

public object TrafficPolicyInstanceMapper : ResourceMapper<TrafficPolicyInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.TrafficPolicyInstance::class == javaResource::class

    override fun map(javaResource: Resource): TrafficPolicyInstance =
        TrafficPolicyInstance(javaResource as com.pulumi.aws.route53.TrafficPolicyInstance)
}

/**
 * @see [TrafficPolicyInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficPolicyInstance].
 */
public suspend fun trafficPolicyInstance(
    name: String,
    block: suspend TrafficPolicyInstanceResourceBuilder.() -> Unit,
): TrafficPolicyInstance {
    val builder = TrafficPolicyInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficPolicyInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficPolicyInstance(name: String): TrafficPolicyInstance {
    val builder = TrafficPolicyInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
