@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.TrafficPolicyInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route53 traffic policy instance resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.route53.TrafficPolicyInstance("test", {
 *     name: "test.example.com",
 *     trafficPolicyId: "b3gb108f-ea6f-45a5-baab-9d112d8b4037",
 *     trafficPolicyVersion: 1,
 *     hostedZoneId: "Z033120931TAQO548OGJC",
 *     ttl: 360,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.route53.TrafficPolicyInstance("test",
 *     name="test.example.com",
 *     traffic_policy_id="b3gb108f-ea6f-45a5-baab-9d112d8b4037",
 *     traffic_policy_version=1,
 *     hosted_zone_id="Z033120931TAQO548OGJC",
 *     ttl=360)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Route53.TrafficPolicyInstance("test", new()
 *     {
 *         Name = "test.example.com",
 *         TrafficPolicyId = "b3gb108f-ea6f-45a5-baab-9d112d8b4037",
 *         TrafficPolicyVersion = 1,
 *         HostedZoneId = "Z033120931TAQO548OGJC",
 *         Ttl = 360,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := route53.NewTrafficPolicyInstance(ctx, "test", &route53.TrafficPolicyInstanceArgs{
 * 			Name:                 pulumi.String("test.example.com"),
 * 			TrafficPolicyId:      pulumi.String("b3gb108f-ea6f-45a5-baab-9d112d8b4037"),
 * 			TrafficPolicyVersion: pulumi.Int(1),
 * 			HostedZoneId:         pulumi.String("Z033120931TAQO548OGJC"),
 * 			Ttl:                  pulumi.Int(360),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.TrafficPolicyInstance;
 * import com.pulumi.aws.route53.TrafficPolicyInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TrafficPolicyInstance("test", TrafficPolicyInstanceArgs.builder()
 *             .name("test.example.com")
 *             .trafficPolicyId("b3gb108f-ea6f-45a5-baab-9d112d8b4037")
 *             .trafficPolicyVersion(1)
 *             .hostedZoneId("Z033120931TAQO548OGJC")
 *             .ttl(360)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:route53:TrafficPolicyInstance
 *     properties:
 *       name: test.example.com
 *       trafficPolicyId: b3gb108f-ea6f-45a5-baab-9d112d8b4037
 *       trafficPolicyVersion: 1
 *       hostedZoneId: Z033120931TAQO548OGJC
 *       ttl: 360
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Route53 traffic policy instance using its id. For example:
 * ```sh
 * $ pulumi import aws:route53/trafficPolicyInstance:TrafficPolicyInstance test df579d9a-6396-410e-ac22-e7ad60cf9e7e
 * ```
 * @property hostedZoneId ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
 * @property name Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
 * @property trafficPolicyId ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
 * @property trafficPolicyVersion Version of the traffic policy
 * @property ttl TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
 */
public data class TrafficPolicyInstanceArgs(
    public val hostedZoneId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val trafficPolicyId: Output<String>? = null,
    public val trafficPolicyVersion: Output<Int>? = null,
    public val ttl: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.TrafficPolicyInstanceArgs> {
    override fun toJava(): com.pulumi.aws.route53.TrafficPolicyInstanceArgs =
        com.pulumi.aws.route53.TrafficPolicyInstanceArgs.builder()
            .hostedZoneId(hostedZoneId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .trafficPolicyId(trafficPolicyId?.applyValue({ args0 -> args0 }))
            .trafficPolicyVersion(trafficPolicyVersion?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficPolicyInstanceArgs].
 */
@PulumiTagMarker
public class TrafficPolicyInstanceArgsBuilder internal constructor() {
    private var hostedZoneId: Output<String>? = null

    private var name: Output<String>? = null

    private var trafficPolicyId: Output<String>? = null

    private var trafficPolicyVersion: Output<Int>? = null

    private var ttl: Output<Int>? = null

    /**
     * @param value ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
     */
    @JvmName("niyrklxhioofpwgx")
    public suspend fun hostedZoneId(`value`: Output<String>) {
        this.hostedZoneId = value
    }

    /**
     * @param value Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
     */
    @JvmName("eyowuyqkrctkkaru")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
     */
    @JvmName("umffexqdoninuxto")
    public suspend fun trafficPolicyId(`value`: Output<String>) {
        this.trafficPolicyId = value
    }

    /**
     * @param value Version of the traffic policy
     */
    @JvmName("rmcknultcejaspot")
    public suspend fun trafficPolicyVersion(`value`: Output<Int>) {
        this.trafficPolicyVersion = value
    }

    /**
     * @param value TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
     */
    @JvmName("oaolrrpnhwnowunf")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
     */
    @JvmName("vlwlbilywydbatte")
    public suspend fun hostedZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostedZoneId = mapped
    }

    /**
     * @param value Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
     */
    @JvmName("vuvvaqkoljaovhqo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
     */
    @JvmName("bbldxhhejwlgisio")
    public suspend fun trafficPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficPolicyId = mapped
    }

    /**
     * @param value Version of the traffic policy
     */
    @JvmName("jrcxouoimxutmmle")
    public suspend fun trafficPolicyVersion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficPolicyVersion = mapped
    }

    /**
     * @param value TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
     */
    @JvmName("tkxygsfoudevlucr")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    internal fun build(): TrafficPolicyInstanceArgs = TrafficPolicyInstanceArgs(
        hostedZoneId = hostedZoneId,
        name = name,
        trafficPolicyId = trafficPolicyId,
        trafficPolicyVersion = trafficPolicyVersion,
        ttl = ttl,
    )
}
